/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.toolbox.notification.builders;

import org.eclipse.papyrus.infra.widgets.toolbox.notification.IBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.ICompositeCreator;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.INotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.PropertyWrapper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.dialogs.AsyncNotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.dialogs.ImagePapyrusAsyncNotificationPopup;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.dialogs.PapyrusAsyncNotificationPopup;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.utils.PapyrusControlsFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AsyncNotifierBuilder
implements IBuilder {
    @Override
    public INotification build(PropertyWrapper wrapper, FormToolkit toolkit) {
        PapyrusAsyncNotificationPopup popup = null;
        if (wrapper.getComposite() != null) {
            final ICompositeCreator composite = wrapper.getComposite();
            popup = wrapper.getType() != null ? new ImagePapyrusAsyncNotificationPopup(Display.getDefault(), toolkit, wrapper.getType()){

                @Override
                protected void doCreateClient(Composite parent) {
                    PapyrusControlsFactory.createCompositeWithType(this.getShell(), null, parent, this.type, this.image, this.text, false, composite, this.context);
                }
            } : new PapyrusAsyncNotificationPopup(Display.getDefault(), toolkit){

                @Override
                protected void doCreateClient(Composite parent) {
                    Composite compo = composite.createComposite(parent, this.toolkit);
                    this.setCompositeCreated(compo);
                }
            };
        } else {
            popup = wrapper.getType() != null ? new ImagePapyrusAsyncNotificationPopup(Display.getDefault(), toolkit, wrapper.getType()) : new PapyrusAsyncNotificationPopup(Display.getDefault(), toolkit);
            String text = wrapper.getMessage();
            if (text == null) {
                text = "no text";
            }
            popup.setText(text);
        }
        if (wrapper.getDelay() != null) {
            popup.setDelayClose(wrapper.getDelay());
        }
        if (wrapper.getActions() != null) {
            popup.addAllRunnable(wrapper.getActions());
        }
        popup.setTitle(wrapper.getTitle() == null ? "Papyrus" : wrapper.getTitle());
        AsyncNotification notification = new AsyncNotification(popup);
        popup.setINotification(notification);
        popup.open();
        return notification;
    }

    @Override
    public boolean accept(String parameterName, Object value) {
        if ("asynchronous".equals(parameterName)) {
            return value instanceof Boolean && (Boolean)value != false;
        }
        if ("temporary".equals(parameterName)) {
            return value instanceof Boolean && (Boolean)value != false;
        }
        if ("message".equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.COMPOSITE.equals(parameterName)) {
            return true;
        }
        if ("default_action".equals(parameterName)) {
            return true;
        }
        if ("delay".equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.IMAGE.equals(parameterName)) {
            return true;
        }
        if ("type".equals(parameterName)) {
            return true;
        }
        if ("html".equals(parameterName)) {
            return value instanceof Boolean && (Boolean)value == false;
        }
        return "title".equals(parameterName);
    }
}

