/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.core.utils.IExecutorPolicy;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.tools.util.CoreExecutors;
import org.eclipse.swt.widgets.Display;

public class TransactionUIHelper {
    private static final Executor uiExecutor = CoreExecutors.getUIExecutorService();
    private static final LoadingCache<TransactionalEditingDomain, Executor> domainExecutors = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<TransactionalEditingDomain, Executor>(){

        public Executor load(TransactionalEditingDomain domain) {
            IExecutorPolicy policy = new IExecutorPolicy(){

                public IExecutorPolicy.Ranking rank(Runnable task, Executor executor) {
                    if (executor == uiExecutor) {
                        return IExecutorPolicy.Ranking.ACCEPTABLE;
                    }
                    return Display.getCurrent() == null ? IExecutorPolicy.Ranking.DEPRECATED : IExecutorPolicy.Ranking.PREFERRED;
                }
            };
            return TransactionHelper.createTransactionExecutor((TransactionalEditingDomain)domain, (Executor)uiExecutor, (IExecutorPolicy)policy, (Map)TransactionHelper.mergeReadOnlyOption((boolean)true));
        }
    });

    public static Executor getExecutor(TransactionalEditingDomain domain) {
        return domain != null ? (Executor)domainExecutors.getUnchecked((Object)domain) : uiExecutor;
    }

    public static IRunnableWithProgress createPrivilegedRunnableWithProgress(TransactionalEditingDomain domain, final IRunnableWithProgress runnable) {
        final IProgressMonitor[] monitorHolder = new IProgressMonitor[1];
        RunnableWithResult privileged = domain.createPrivilegedRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        runnable.run(monitorHolder[0]);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new WrappedException(e);
                    }
                }
                finally {
                    monitorHolder[0] = null;
                }
            }
        });
        return new PrivilegedRunnableWithProgress((Runnable)privileged, m -> {
            IProgressMonitor iProgressMonitor = m;
        });
    }

    private static final class PrivilegedRunnableWithProgress
    implements IRunnableWithProgress {
        private final Consumer<? super IProgressMonitor> monitorSlot;
        private Runnable privileged;

        PrivilegedRunnableWithProgress(Runnable privileged, Consumer<? super IProgressMonitor> monitorSlot) {
            this.monitorSlot = monitorSlot;
            this.privileged = privileged;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (this.privileged == null) {
                throw new IllegalStateException("Privileged runnable was already run");
            }
            this.monitorSlot.accept((IProgressMonitor)monitor);
            try {
                try {
                    this.privileged.run();
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getLocalizedMessage());
                }
                catch (WrappedException e) {
                    Exception unwrapped = e.exception();
                    if (unwrapped instanceof InvocationTargetException) {
                        throw (InvocationTargetException)unwrapped;
                    }
                    if (unwrapped instanceof InterruptedException) {
                        throw (InterruptedException)unwrapped;
                    }
                    throw e;
                }
            }
            finally {
                this.privileged = null;
            }
        }
    }
}

