/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.usecase.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.locator.RoundedRectangleLabelPositionLocator;

public class ActorFloatingLabelLocator
extends RoundedRectangleLabelPositionLocator {
    protected static final int SPACE_BEETWEN_ACTOR_AND_LABEL = 5;
    protected static final int DEFAULT_ACTOR_LABEL_X_POSITION = 0;
    protected static final int DEFAULT_ACTOR_LABEL_Y_POSITION = 15;

    public ActorFloatingLabelLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint, int interval) {
        super(borderItem, parentFigure, constraint, interval);
    }

    public ActorFloatingLabelLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public ActorFloatingLabelLocator(IFigure parentFigure, int preferredSide, int interval) {
        super(parentFigure, preferredSide, interval);
    }

    public ActorFloatingLabelLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public ActorFloatingLabelLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public ActorFloatingLabelLocator(int interval, IFigure parentFigure) {
        super(interval, parentFigure);
    }

    private Point getDefaultLocation(Rectangle labelFigure, Rectangle actorRect) {
        int X = actorRect.x + actorRect.width / 2 - labelFigure.width / 2;
        int Y = actorRect.y + actorRect.height + 5;
        return new Point(X, Y);
    }

    public void relocate(IFigure target) {
        Dimension size = this.getSize(target);
        Rectangle rectSuggested = this.getConstraint().getCopy();
        if (rectSuggested.getTopLeft().x == 0 && rectSuggested.getTopLeft().y == 15) {
            rectSuggested.setLocation(this.getDefaultLocation(target.getBounds().getCopy(), this.getParentBorder()));
            rectSuggested.setSize(size);
            target.setBounds(rectSuggested);
        } else {
            super.relocate(target);
        }
    }
}

