/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Location implements Enumerator
{
    BEFORE(0, "Before", "BEFORE"),
    AFTER(1, "After", "AFTER");

    public static final int BEFORE_VALUE = 0;
    public static final int AFTER_VALUE = 1;
    private static final Location[] VALUES_ARRAY;
    public static final List<Location> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Location[]{BEFORE, AFTER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Location get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Location result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Location getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Location result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Location get(int value) {
        switch (value) {
            case 0: {
                return BEFORE;
            }
            case 1: {
                return AFTER;
            }
        }
        return null;
    }

    private Location(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

