/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.constraints.constraints;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.infra.constraints.constraints.AbstractConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;

public class CompoundConstraint
extends AbstractConstraint {
    private List<Constraint> constraints = new LinkedList<Constraint>();

    public void addConstraint(Constraint subConstraint) {
        if (subConstraint == null) {
            throw new IllegalArgumentException("The subConstraint shall not be null");
        }
        this.constraints.add(subConstraint);
    }

    @Override
    public boolean match(Collection<?> selection) {
        for (Constraint constraint : this.constraints) {
            if (constraint.match(selection)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean match(Object selection) {
        return false;
    }

    @Override
    public boolean overrides(Constraint constraint) {
        if (this.constraints.size() == 0) {
            return false;
        }
        if (this.constraints.size() == 1) {
            return this.constraints.get(0).overrides(constraint);
        }
        if (constraint instanceof CompoundConstraint) {
            boolean atLeastOneOverride = false;
            for (Constraint subConstraint : this.constraints) {
                boolean equalsOrOverride = false;
                for (Constraint otherSubConstraint : ((CompoundConstraint)constraint).constraints) {
                    if (subConstraint.overrides(otherSubConstraint)) {
                        atLeastOneOverride = true;
                        break;
                    }
                    if (!subConstraint.equals(otherSubConstraint)) continue;
                    equalsOrOverride = true;
                }
                if (equalsOrOverride) continue;
                return false;
            }
            if (atLeastOneOverride) {
                return true;
            }
        } else {
            for (Constraint c : this.constraints) {
                if (!c.overrides(constraint) && !c.equals(constraint)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.constraints.toString();
    }

    @Override
    protected boolean equivalent(Constraint constraint) {
        return false;
    }
}

