/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.reconciler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;

public abstract class ReconcilerForCompartment
extends DiagramReconciler {
    @Override
    public ICommand getReconcileCommand(Diagram diagram) {
        return new UpdateCompartmentsCommand(diagram);
    }

    public abstract List<String> getCompartmentsVisualID();

    protected boolean isCompartment(View view) {
        return this.getCompartmentsVisualID().contains(view.getType());
    }

    protected class UpdateCompartmentsCommand
    extends AbstractCommand {
        protected final Diagram diagram;

        public UpdateCompartmentsCommand(Diagram diagram) {
            super("Update Compartment notation element");
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            TreeIterator allContentIterator = this.diagram.eAllContents();
            ArrayList<DecorationNode> oldComparments = new ArrayList<DecorationNode>();
            while (allContentIterator.hasNext()) {
                EObject eObject = (EObject)allContentIterator.next();
                if (!(eObject instanceof DecorationNode) || eObject instanceof BasicCompartment || !ReconcilerForCompartment.this.isCompartment((View)eObject)) continue;
                oldComparments.add((DecorationNode)eObject);
            }
            for (DecorationNode oldCompartment : oldComparments) {
                BasicCompartment newCompartment = NotationFactory.eINSTANCE.createBasicCompartment();
                newCompartment.setType(oldCompartment.getType());
                newCompartment.setVisible(oldCompartment.isVisible());
                newCompartment.setMutable(oldCompartment.isMutable());
                newCompartment.setLayoutConstraint(oldCompartment.getLayoutConstraint());
                newCompartment.getStyles().addAll((Collection)oldCompartment.getStyles());
                newCompartment.getPersistedChildren().addAll((Collection)oldCompartment.getPersistedChildren());
                if (oldCompartment.isSetElement()) {
                    newCompartment.setElement(oldCompartment.getElement());
                }
                EcoreUtil.replace((EObject)oldCompartment, (EObject)newCompartment);
            }
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }
}

