/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.AddCssClassStyleCommand;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.widgets.editors.InputDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class ApplyStyleHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection = ServiceUtilsForHandlers.getInstance().getNestedActiveIEditorPart(event).getSite().getSelectionProvider().getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                Shell parentShell;
                InputDialog dialog;
                int result;
                Iterator iterator = ((IStructuredSelection)selection).iterator();
                ArrayList<View> selectedViews = new ArrayList<View>();
                while (iterator.hasNext()) {
                    Object it = iterator.next();
                    View view = NotationHelper.findView(it);
                    if (view == null) continue;
                    selectedViews.add(view);
                }
                if (!selectedViews.isEmpty() && (result = (dialog = new InputDialog(parentShell = ((Event)event.getTrigger()).widget.getDisplay().getActiveShell(), Messages.StringEditionFactory_EnterANewValue, Messages.StringEditionFactory_EnterANewValue, "", null)).open()) == 0) {
                    String newStyleValue = dialog.getText();
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)((EObject)selectedViews.get(0)));
                    AddCssClassStyleCommand addCssClassStyleCommand = new AddCssClassStyleCommand(editingDomain, selectedViews, newStyleValue);
                    editingDomain.getCommandStack().execute((Command)addCssClassStyleCommand);
                    return newStyleValue;
                }
            }
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        return null;
    }
}

