/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.axis;

import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.axis.CompositeAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.ITreeItemAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.table.TreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.EventListHelper;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;

public class CompositeTreeAxisManagerForEventList
extends CompositeAxisManagerForEventList
implements ITreeItemAxisManagerForEventList {
    private static final String MANAGER_ID = "org.eclipse.papyrus.infra.nattable.composite.tree.axis.manager.event.list";

    public CompositeTreeAxisManagerForEventList(EventList<Object> eventList) {
        super(eventList);
    }

    @Override
    public void setSubManagers(List<IAxisManagerForEventList> subManagers) {
        super.setSubManagers(subManagers);
        this.fillListWithRoots();
    }

    @Override
    public void manageEvent(Notification notification) {
        super.manageEvent(notification);
    }

    @Override
    public void fillListWithChildren(ITreeItemAxis axis) {
        for (IAxisManager current : this.subManagers) {
            if (!(current instanceof ITreeItemAxisManagerForEventList)) continue;
            ((ITreeItemAxisManagerForEventList)current).fillListWithChildren(axis);
        }
        this.getTableManager().refreshNatTable();
    }

    @Override
    public boolean isAllowedContents(Object objectToTest, Object semanticParent, TreeFillingConfiguration conf, int depth) {
        if (this.isInitialConfiguration(conf)) {
            for (IAxisManager current : this.subManagers) {
                if (!(current instanceof ITreeItemAxisManagerForEventList) || !((ITreeItemAxisManagerForEventList)current).isAllowedContents(objectToTest, semanticParent, conf, depth)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private final boolean isInitialConfiguration(TreeFillingConfiguration conf) {
        if (EMFHelper.isReadOnly((EObject)conf)) {
            return true;
        }
        TableHeaderAxisConfiguration axisConf = (TableHeaderAxisConfiguration)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(this.getTableManager().getTable());
        for (IAxisConfiguration curr : axisConf.getOwnedAxisConfigurations()) {
            if (!(curr instanceof TreeFillingConfiguration)) continue;
            TreeFillingConfiguration treeConf = (TreeFillingConfiguration)curr;
            Object representedElement = treeConf.getAxisUsedAsAxisProvider().getElement();
            return representedElement.equals(conf.getAxisUsedAsAxisProvider().getElement());
        }
        return false;
    }

    @Override
    public int compare(ISortModel sortModel, int depth, ITreeItemAxis axis1, ITreeItemAxis axis2) {
        AxisManagerRepresentation manager1 = axis1.getManager();
        AxisManagerRepresentation manager2 = axis2.getManager();
        if (manager1 == null || manager2 == null) {
            return 0;
        }
        if (manager1 == manager2) {
            for (IAxisManagerForEventList current : this.subManagers) {
                if (current.getAxisManagerRepresentation() != manager1) continue;
                return ((ITreeItemAxisManagerForEventList)current).compare(sortModel, depth, axis1, axis2);
            }
        }
        return 0;
    }

    @Override
    public void setExpanded(ITreeItemAxis element, List<ITreeItemAxis> path, boolean expanded) {
        for (IAxisManager current : this.subManagers) {
            if (element.getManager() != current.getAxisManagerRepresentation() || !(current instanceof ITreeItemAxisManagerForEventList)) continue;
            ((ITreeItemAxisManagerForEventList)current).setExpanded(element, path, expanded);
        }
        final SetCommand cmd = new SetCommand((EditingDomain)this.getTableEditingDomain(), (EObject)element, (EStructuralFeature)NattableaxisPackage.eINSTANCE.getITreeItemAxis_Expanded(), (Object)expanded);
        try {
            if (this.getTableEditingDomain() != null) {
                GMFUnsafe.write((TransactionalEditingDomain)this.getTableEditingDomain(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        cmd.execute();
                    }
                });
            } else {
                cmd.execute();
            }
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
        catch (RollbackException e) {
            Activator.log.error((Throwable)e);
        }
        this.getTableManager().refreshNatTable();
    }

    @Override
    public void fillListWithRoots() {
        for (Object current : this.getRepresentedContentProvider().getAxis()) {
            if (!(current instanceof ITreeItemAxis)) continue;
            EventListHelper.addToEventList((EventList<Object>)this.eventList, current);
        }
        for (Object current : this.subManagers) {
            if (!(current instanceof ITreeItemAxisManagerForEventList)) continue;
            ((ITreeItemAxisManagerForEventList)current).fillListWithRoots();
        }
        this.getTableManager().refreshNatTable();
    }

    @Override
    public void managedHideShowCategoriesForDepth(List<Integer> toHide, List<Integer> toShow) {
        for (IAxisManager current : this.subManagers) {
            if (!(current instanceof ITreeItemAxisManagerForEventList)) continue;
            ((ITreeItemAxisManagerForEventList)current).managedHideShowCategoriesForDepth(toHide, toShow);
        }
        this.getTableManager().refreshNatTable();
    }

    @Override
    public void fillingConfigurationsHaveChanged() {
        super.fillingConfigurationsHaveChanged();
        ArrayList<Integer> depths = new ArrayList<Integer>();
        int i = 0;
        while (i <= FillingConfigurationUtils.getMaxDepthForTree(this.getTableManager().getTable())) {
            depths.add(i);
            ++i;
        }
        ((TreeNattableModelManager)this.getTableManager()).hideShowCategories(null, depths);
        List<Integer> hiddenDepth = StyleUtils.getHiddenDepths(this.getTableManager());
        if (hiddenDepth.size() > 0) {
            ((TreeNattableModelManager)this.getTableManager()).hideShowCategories(hiddenDepth, null);
        }
        this.getTableManager().refreshNatTable();
    }
}

