/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.navigation.navigableElement;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationContributor;
import org.eclipse.papyrus.uml.navigation.navigableElement.ConnectorEndNavigableElement;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;

public class ConnectorNavigationContributor
implements NavigationContributor {
    public List<NavigableElement> getNavigableElements(Object fromElement) {
        Connector connector;
        LinkedList<NavigableElement> result = new LinkedList<NavigableElement>();
        Element element = UMLUtil.resolveUMLElement((Object)fromElement);
        if (element instanceof Connector && (connector = (Connector)element).getEnds().size() > 0) {
            for (ConnectorEnd end : connector.getEnds()) {
                if (end.getRole() != null) {
                    result.add((NavigableElement)new ConnectorEndNavigableElement(end, ConnectorEndNavigableElement.ConnectorEndDerivedFeatureKind.ROLE));
                }
                if (end.getPartWithPort() != null) {
                    result.add((NavigableElement)new ConnectorEndNavigableElement(end, ConnectorEndNavigableElement.ConnectorEndDerivedFeatureKind.PART_WITH_PORT));
                }
                if (end.getDefiningEnd() == null) continue;
                result.add((NavigableElement)new ConnectorEndNavigableElement(end, ConnectorEndNavigableElement.ConnectorEndDerivedFeatureKind.DEFINING_END));
            }
        }
        return result;
    }
}

