/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.papyrus.infra.sync.internal.SyncService;

public abstract class SyncServiceOperation<V>
implements Callable<V> {
    private final SyncService service;

    public SyncServiceOperation(SyncService service) {
        this.service = service;
    }

    @Override
    public final V call() throws Exception {
        return this.service.perform(this);
    }

    public final <X extends Throwable> V safeCall(Class<X> expected) throws X {
        V result;
        try {
            result = this.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                e = (Exception)t;
            } else if (e instanceof WrappedException) {
                e = ((WrappedException)e).exception();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (expected.isInstance(e)) {
                throw (Throwable)expected.cast(e);
            }
            throw new UndeclaredThrowableException(e);
        }
        return result;
    }

    public final V safeCall() {
        return this.safeCall(RuntimeException.class);
    }

    protected abstract V doCall() throws Exception;
}

