/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.editor.DiagramEditorUtil;

@Singleton
public class CreationWizardPage {
    @Inject
    @Extension
    private CodeStyle _codeStyle;
    @Inject
    @Extension
    private Common _common;
    @Inject
    private Externalizer xptExternalizer;
    @Inject
    private DiagramEditorUtil xptDiagramEditorUtil;

    public CharSequence className(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _creationWizardPageClassName = it.getCreationWizardPageClassName();
        _builder.append(_creationWizardPageClassName);
        return _builder;
    }

    public CharSequence packageName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getEditorGen().getEditor().getPackageName();
        _builder.append(_packageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence extendsList(GenDiagram it) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("extends ");
        GenApplication _application = it.getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("org.eclipse.ui.dialogs.WizardNewFileCreationPage");
        } else {
            String _packageName = it.getEditorGen().getApplication().getPackageName();
            _builder.append(_packageName);
            _builder.append(".WizardNewFileCreationPage");
        }
        return _builder;
    }

    public CharSequence CreationWizardPage(GenDiagram it) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" ");
        CharSequence _extendsList = this.extendsList(it);
        _builder.append((Object)_extendsList);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private final String fileExtension;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _className_1 = this.className(it);
        _builder.append((Object)_className_1, "\t");
        _builder.append("(String pageName, org.eclipse.jface.viewers.IStructuredSelection selection, String fileExtension) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("super(pageName, selection);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this.fileExtension = fileExtension;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment("Override to create files with this extension.");
        _builder.append((Object)_generatedMemberComment_2, "\t");
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected String getExtension() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return fileExtension;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public org.eclipse.emf.common.util.URI getURI() {");
        _builder.newLine();
        GenApplication _application = it.getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("\t");
            _builder.append("return org.eclipse.emf.common.util.URI.createPlatformResourceURI(getFilePath().toString(), false);");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("return org.eclipse.emf.common.util.URI.createFileURI(getFilePath().toString());");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        GenApplication _application_1 = it.getEditorGen().getApplication();
        boolean bl2 = _tripleEquals_1 = _application_1 == null;
        if (_tripleEquals_1) {
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_4, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("protected org.eclipse.core.runtime.IPath getFilePath() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("org.eclipse.core.runtime.IPath path = getContainerFullPath();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (path == null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("path = new org.eclipse.core.runtime.Path(\"\"); //$NON-NLS-1$");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("String fileName = getFileName();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (fileName != null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("path = path.append(fileName);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return path;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public void createControl(org.eclipse.swt.widgets.Composite parent) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("super.createControl(parent);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("setFileName(");
        CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t\t");
        _builder.append(".getUniqueFileName(getContainerFullPath(), getFileName(), getExtension()));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("setPageComplete(validatePage());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_6, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _overrideC_1 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected boolean validatePage() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (!super.validatePage()) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("String extension = getExtension();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (extension != null && !getFilePath().toString().endsWith(\".\" + extension)) { ");
        CharSequence _nonNLS = this._common.nonNLS();
        _builder.append((Object)_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("setErrorMessage(org.eclipse.osgi.util.NLS.bind(");
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForCreationWizardPageExtensionError(it));
        _builder.append((Object)_accessorCall, "\t\t\t");
        _builder.append(", extension));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence i18nValues(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForCreationWizardPageExtensionError(it), "File name should have {0} extension.");
        _builder.append((Object)_messageEntry);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence i18nAccessors(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForCreationWizardPageExtensionError(it));
        _builder.append((Object)_accessorField);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public String i18nKeyForCreationWizardPageExtensionError(GenDiagram diagram) {
        CharSequence _className = this.className(diagram);
        return _className + "ExtensionError";
    }
}

