/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.helper.advice;

import java.util.Collection;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.OperationForbiddenException;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.uml2.uml.StateInvariant;

public class StateInvariantHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getAfterDestroyDependentsCommand(DestroyDependentsRequest request) {
        EObject destructee = request.getElementToDestroy();
        if (destructee instanceof StateInvariant) {
            try {
                StateInvariant stateInvariant = (StateInvariant)destructee;
                Collection<EObject> elementsToDestroy = StateInvariantUtils.getElementsToDelete(stateInvariant);
                if (!elementsToDestroy.isEmpty()) {
                    CompositeCommand compositeCommand = new CompositeCommand(Messages.StateInvariantHelperAdvice_DestroyStateInvariant);
                    for (EObject eObject : elementsToDestroy) {
                        DestroyElementRequest destroyElementRequest = new DestroyElementRequest(eObject, false);
                        compositeCommand.add((IUndoableOperation)new DestroyElementCommand(destroyElementRequest));
                    }
                    IUndoableOperation updateFragmentNamesCommand = LifelineUtils.getUpdateFragmentNamesCommand((EObject)stateInvariant);
                    if (updateFragmentNamesCommand != null) {
                        compositeCommand.add(updateFragmentNamesCommand);
                    }
                    return compositeCommand;
                }
            }
            catch (OperationForbiddenException e) {
                return UnexecutableCommand.INSTANCE;
            }
        }
        return null;
    }
}

