/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.connectionpointreference.xtext.ui.contributions;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.textedit.connectionpointreference.xtext.ui.internal.UMLConnectionPointReferenceActivator;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.uml2.uml.ConnectionPointReference;
import org.eclipse.uml2.uml.Pseudostate;

public class ConnectionPointReferenceEditorConfiguration
extends DefaultXtextDirectEditorConfiguration {
    private ConnectionPointReference connectionPoint;
    private List<Pseudostate> newEntries = new ArrayList<Pseudostate>();
    private List<Pseudostate> newExits = new ArrayList<Pseudostate>();

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof ConnectionPointReference) {
            ConnectionPointReference ref = (ConnectionPointReference)editedObject;
            String label = "";
            if (!ref.getEntries().isEmpty()) {
                label = String.valueOf(label) + "entry ";
                boolean first = true;
                for (Pseudostate p : ref.getEntries()) {
                    if (!first) {
                        label = String.valueOf(label) + ", ";
                    } else {
                        first = false;
                    }
                    label = String.valueOf(label) + p.getName();
                }
            } else if (!ref.getExits().isEmpty()) {
                label = String.valueOf(label) + "exit ";
                boolean first = true;
                for (Pseudostate p : ref.getExits()) {
                    if (!first) {
                        label = String.valueOf(label) + ", ";
                    } else {
                        first = false;
                    }
                    label = String.valueOf(label) + p.getName();
                }
            }
            return label;
        }
        return "not a ConnectionPointReference";
    }

    static TransactionalEditingDomain getEditingDomain(EObject context) {
        try {
            return ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)context);
        }
        catch (ServiceException ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    public Injector getInjector() {
        return UMLConnectionPointReferenceActivator.getInstance().getInjector("org.eclipse.papyrus.uml.textedit.connectionpointreference.xtext.UMLConnectionPointReference");
    }

    protected ICommand getParseCommand(EObject umlObject, EObject xtextObject) {
        return new UpdateConnectionPointReferenceCommand((ConnectionPointReference)umlObject);
    }

    protected class UpdateConnectionPointReferenceCommand
    extends AbstractTransactionalCommand {
        private ConnectionPointReference connectionPointReference;

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            this.connectionPointReference.getEntries().clear();
            this.connectionPointReference.getExits().clear();
            this.connectionPointReference.getEntries().addAll(ConnectionPointReferenceEditorConfiguration.this.newEntries);
            this.connectionPointReference.getExits().addAll(ConnectionPointReferenceEditorConfiguration.this.newExits);
            return CommandResult.newOKCommandResult((Object)this.connectionPointReference);
        }

        public UpdateConnectionPointReferenceCommand(ConnectionPointReference connectionPointReference) {
            super(ConnectionPointReferenceEditorConfiguration.getEditingDomain((EObject)connectionPointReference), "ConnectionPointReference Update", UpdateConnectionPointReferenceCommand.getWorkspaceFiles((EObject)connectionPointReference));
            this.connectionPointReference = connectionPointReference;
        }
    }
}

