/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.directedit.locator;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;

public class TextCellEditorLocator
implements CellEditorLocator {
    private WrappingLabel myWrapLabel;

    public TextCellEditorLocator(WrappingLabel wrapLabel) {
        this.myWrapLabel = wrapLabel;
    }

    public WrappingLabel getWrapLabel() {
        return this.myWrapLabel;
    }

    public void relocate(CellEditor celleditor) {
        Control text = celleditor.getControl();
        Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
        this.getWrapLabel().translateToAbsolute((Translatable)rect);
        if (this.getWrapLabel().isTextWrapOn() && this.getWrapLabel().getText().length() > 0) {
            rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
        } else {
            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
        }
        if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
            text.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }
}

