/*****************************************************************************
 * Copyright (c) 2011 Atos.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Atos - Initial API and implementation
 *   Arthur Daussy Bug 366159 - [ActivityDiagram] Activity Diagram should be able to handle correctly Interruptible Edge
 *
 *****************************************************************************/
package org.eclipse.papyrus.uml.diagram.activity.edit.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ObjectFlowInterruptibleIconEditPart;
import org.eclipse.papyrus.uml.diagram.activity.figures.InterruptibleEdgeExternalIconFigure;
import org.eclipse.swt.graphics.Image;

/**
 * Customization to be able to handle specific image label edit part.
 * In this case the label is an InterruptibleEdgeExternalIconFigure which specific handle
 *
 * @author arthur daussy
 *
 */
public class CustomObjectFlowInterruptibleIconEditPart extends ObjectFlowInterruptibleIconEditPart {

	public CustomObjectFlowInterruptibleIconEditPart(View view) {
		super(view);
	}

	/**
	 * Make it handle with {@link InterruptibleEdgeExternalIconFigure}
	 */
	@Override
	protected String getLabelTextHelper(IFigure figure) {
		if (figure instanceof InterruptibleEdgeExternalIconFigure) {
			return "";
		}
		return super.getLabelTextHelper(figure);
	}

	/**
	 * Make it handle with {@link InterruptibleEdgeExternalIconFigure}
	 */
	@Override
	protected void setLabelTextHelper(IFigure figure, String text) {
		if (figure instanceof InterruptibleEdgeExternalIconFigure) {
			// Label can not be set on this figure
			return;
		}
		super.getLabelTextHelper(figure);
	}

	/**
	 * Make it handle with {@link InterruptibleEdgeExternalIconFigure}
	 */
	@Override
	protected Image getLabelIconHelper(IFigure figure) {
		if (figure instanceof InterruptibleEdgeExternalIconFigure) {
			return ((InterruptibleEdgeExternalIconFigure) figure).getImage();
		}
		return super.getLabelIconHelper(figure);
	}

	/**
	 * Make it handle with {@link InterruptibleEdgeExternalIconFigure}
	 */
	@Override
	protected void setLabelIconHelper(IFigure figure, Image icon) {
		if (figure instanceof InterruptibleEdgeExternalIconFigure) {
			// Icon can not be set on this figure
			return;
		}
		super.setLabelIconHelper(figure, icon);
	}
}
