/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.model;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.DoubleValueStyle;
import org.eclipse.gmf.runtime.notation.EObjectValueStyle;
import org.eclipse.gmf.runtime.notation.IntValueStyle;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringListValueStyle;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.style.PapyrusDiagramStyle;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForActionHandlers;

public class NotationUtils {
    @Deprecated
    public static Resource getNotationResource() {
        return NotationUtils.getNotationModel().getResource();
    }

    public static NotationModel getNotationModel() {
        try {
            return (NotationModel)ServiceUtilsForActionHandlers.getInstance().getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static NotationModel getNotationModelChecked() throws ServiceException {
        return (NotationModel)ServiceUtilsForActionHandlers.getInstance().getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
    }

    public static NotationModel getNotationModel(ModelSet modelsManager) {
        return (NotationModel)modelsManager.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
    }

    public static Diagram getAssociatedDiagram(Resource notationResource, EObject eObject) {
        if (notationResource != null) {
            for (EObject obj : notationResource.getContents()) {
                Diagram diagram;
                if (!(obj instanceof Diagram) || DiagramUtils.getOwner(diagram = (Diagram)obj) != eObject) continue;
                return diagram;
            }
        }
        return null;
    }

    public static Diagram getAssociatedDiagram(Resource notationResource, EObject eObject, boolean resolve) {
        if (notationResource != null && resolve) {
            EcoreUtil.resolveAll((Resource)notationResource);
        }
        return NotationUtils.getAssociatedDiagram(notationResource, eObject);
    }

    public static List<Diagram> getDiagrams(Resource notationResource, EObject eObject) {
        LinkedList<Diagram> diagrams = new LinkedList<Diagram>();
        if (notationResource != null) {
            for (EObject obj : notationResource.getContents()) {
                Diagram diagram;
                if (!(obj instanceof Diagram) || !EcoreUtil.isAncestor((EObject)eObject, (EObject)DiagramUtils.getOwner(diagram = (Diagram)obj))) continue;
                diagrams.add(diagram);
            }
        }
        return diagrams;
    }

    public static Diagram getOwnedDiagram(EObject diagOrViewStyle, EObject owner) {
        PapyrusDiagramStyle viewStyle;
        if (diagOrViewStyle instanceof Diagram) {
            Diagram diagram = (Diagram)diagOrViewStyle;
            if (DiagramUtils.getOwner(diagram) == owner) {
                return diagram;
            }
        } else if (diagOrViewStyle instanceof PapyrusDiagramStyle && (viewStyle = (PapyrusDiagramStyle)diagOrViewStyle).getOwner() == owner && viewStyle.eContainer() instanceof Diagram) {
            return (Diagram)viewStyle.eContainer();
        }
        return null;
    }

    public static List<Diagram> getDiagrams(Resource notationResource, EObject eObject, boolean resolve) {
        if (notationResource != null && resolve) {
            EcoreUtil.resolveAll((Resource)notationResource);
        }
        return NotationUtils.getDiagrams(notationResource, eObject);
    }

    public static Iterable<EObject> getAllNotations(ResourceSet resourceSet) {
        return NotationUtils.getAllNotations(resourceSet, EObject.class);
    }

    public static <T extends EObject> Iterable<T> getAllNotations(ResourceSet resourceSet, Class<T> type) {
        return () -> resourceSet.getResources().stream().filter(r -> "notation".equalsIgnoreCase(r.getURI().fileExtension())).map(Resource::getContents).flatMap(Collection::stream).filter(type::isInstance).map(type::cast).iterator();
    }

    public static Resource getNotationResource(ModelSet from) {
        IModel notationModel = from.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        if (notationModel instanceof NotationModel) {
            return ((NotationModel)notationModel).getResource();
        }
        return null;
    }

    public static Resource getNotationResource(ServicesRegistry registry) {
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)registry);
            return NotationUtils.getNotationResource(modelSet);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    public static Resource getNotationResourceForDiagram(EObject eObject, TransactionalEditingDomain domain) {
        Object object = BusinessModelResolver.getInstance().getBusinessModel((Object)eObject);
        EObject semanticObject = !(object instanceof EObject) ? eObject : (EObject)object;
        Resource containerResource = semanticObject.eResource();
        if (containerResource == null) {
            return null;
        }
        ResourceSet resourceSet = containerResource.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)resourceSet;
            Resource destinationResource = modelSet.getAssociatedResource(semanticObject, "notation", true);
            return destinationResource;
        }
        throw new RuntimeException("Resource Set is not a ModelSet or is null");
    }

    public static int getIntValue(View view, String property, int defaultInt) {
        NamedStyle style;
        int value = defaultInt;
        EClass intValueStyle = NotationPackage.eINSTANCE.getIntValueStyle();
        if (intValueStyle != null && (style = view.getNamedStyle(intValueStyle, property)) instanceof IntValueStyle) {
            value = ((IntValueStyle)style).getIntValue();
        }
        return value;
    }

    public static boolean getBooleanValue(View view, String property, boolean defaultValue) {
        NamedStyle style;
        boolean value = defaultValue;
        EClass booleanValueStyle = NotationPackage.eINSTANCE.getBooleanValueStyle();
        if (booleanValueStyle != null && (style = view.getNamedStyle(booleanValueStyle, property)) instanceof BooleanValueStyle) {
            value = ((BooleanValueStyle)style).isBooleanValue();
        }
        return value;
    }

    public static String getStringValue(View view, String property, String defaultValue) {
        NamedStyle style;
        String value = defaultValue;
        EClass stringValueStyle = NotationPackage.eINSTANCE.getStringValueStyle();
        if (stringValueStyle != null && (style = view.getNamedStyle(stringValueStyle, property)) instanceof StringValueStyle) {
            value = ((StringValueStyle)style).getStringValue();
        }
        return value;
    }

    public static EObject getEObjectValue(View view, String property, EObject defaultValue) {
        NamedStyle style;
        EObject value = defaultValue;
        EClass eObjectValueStyle = NotationPackage.eINSTANCE.getEObjectValueStyle();
        if (eObjectValueStyle != null && (style = view.getNamedStyle(eObjectValueStyle, property)) instanceof EObjectValueStyle) {
            value = ((EObjectValueStyle)style).getEObjectValue();
        }
        return value;
    }

    public static double getDoubleValue(View view, String property, double defaultDouble) {
        NamedStyle style;
        double value = defaultDouble;
        EClass doubleValueStyle = NotationPackage.eINSTANCE.getDoubleValueStyle();
        if (doubleValueStyle != null && (style = view.getNamedStyle(doubleValueStyle, property)) instanceof DoubleValueStyle) {
            value = ((DoubleValueStyle)style).getDoubleValue();
        }
        return value;
    }

    public static int[] getIntListValue(View view, String property, int[] defaultIntList) {
        NamedStyle style;
        int[] value = defaultIntList;
        EClass intValueStyle = NotationPackage.eINSTANCE.getStringListValueStyle();
        if (intValueStyle != null && (style = view.getNamedStyle(intValueStyle, property)) instanceof StringListValueStyle) {
            EList valueList = ((StringListValueStyle)style).getStringListValue();
            int i = 0;
            value = new int[valueList.size()];
            for (String string : valueList) {
                value[i++] = Integer.parseInt(string);
            }
        }
        return value;
    }

    public static EList<String> getStringListValue(View view, String property, EList<String> defaultStringList) {
        NamedStyle style;
        EClass stringValueStyle;
        EList value = defaultStringList;
        if (view != null && property != null && !property.isEmpty() && (stringValueStyle = NotationPackage.eINSTANCE.getStringListValueStyle()) != null && (style = view.getNamedStyle(stringValueStyle, property)) instanceof StringListValueStyle) {
            value = ((StringListValueStyle)style).getStringListValue();
        }
        return value;
    }
}

