/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.provider;

import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.e4.ui.css.core.impl.dom.CSSStyleRuleImpl;
import org.eclipse.e4.ui.css.core.impl.sac.CSSClassConditionImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.StyleSheet;

public class CSSClassContentProvider
extends AbstractStaticContentProvider {
    private String elementName;
    private ExtendedCSSEngine engine;

    public CSSClassContentProvider(String elementName, ExtendedCSSEngine engine) {
        this.elementName = elementName;
        this.engine = engine;
    }

    public Object[] getElements() {
        return this.getAvailableClasses().toArray();
    }

    public Collection<String> getAvailableClasses() {
        TreeSet<Object> result = new TreeSet<Object>(Collator.getInstance());
        for (StyleSheet stylesheet : this.engine.getAllStylesheets()) {
            if (!(stylesheet instanceof CSSStyleSheet)) continue;
            CSSStyleSheet cssStylesheet = (CSSStyleSheet)stylesheet;
            int i = 0;
            while (i < cssStylesheet.getCssRules().getLength()) {
                CSSRule cssRule = cssStylesheet.getCssRules().item(i);
                if (cssRule instanceof CSSStyleRuleImpl) {
                    CSSStyleRuleImpl rule = (CSSStyleRuleImpl)cssRule;
                    int j = 0;
                    while (j < rule.getSelectorList().getLength()) {
                        Selector selector = rule.getSelectorList().item(j);
                        result.addAll(this.findClassesFromSelector(selector));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    protected List<String> findClassesFromSelector(Selector selector) {
        LinkedList<String> result = new LinkedList<String>();
        if (selector instanceof ConditionalSelector) {
            result.addAll(this.findClassesFromSelector((ConditionalSelector)selector));
        } else if (selector instanceof DescendantSelector) {
            result.addAll(this.findClassesFromSelector((Selector)((DescendantSelector)selector).getSimpleSelector()));
            result.addAll(this.findClassesFromSelector(((DescendantSelector)selector).getAncestorSelector()));
        } else if (selector instanceof SiblingSelector) {
            result.addAll(this.findClassesFromSelector(((SiblingSelector)selector).getSelector()));
            result.addAll(this.findClassesFromSelector((Selector)((SiblingSelector)selector).getSiblingSelector()));
        }
        return result;
    }

    protected List<String> findClassesFromSelector(ConditionalSelector selector) {
        ElementSelector elementSelector;
        String localName;
        LinkedList<String> result = new LinkedList<String>();
        SimpleSelector simpleSelector = selector.getSimpleSelector();
        if (simpleSelector instanceof ElementSelector && ("*".equals(localName = (elementSelector = (ElementSelector)simpleSelector).getLocalName()) || "*".equals(this.elementName) || this.elementName.equals(localName) || localName == null)) {
            Condition condition = selector.getCondition();
            result.addAll(this.findClassesFromCondition(condition));
        }
        return result;
    }

    protected List<String> findClassesFromCondition(Condition condition) {
        if (condition instanceof CSSClassConditionImpl) {
            return Collections.singletonList(((CSSClassConditionImpl)condition).getValue());
        }
        if (condition instanceof CombinatorCondition) {
            CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
            LinkedList<String> result = new LinkedList<String>();
            result.addAll(this.findClassesFromCondition(combinatorCondition.getFirstCondition()));
            result.addAll(this.findClassesFromCondition(combinatorCondition.getSecondCondition()));
            return result;
        }
        return Collections.emptyList();
    }
}

