/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.internal.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.facet.architecture.api.CustomizationFacetFactory;
import org.eclipse.papyrus.emf.facet.architecture.api.ICustomizationReferenceMerger;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.CustomizationConfigurationPackage;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.EMFFacetTreeViewerConfiguration;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.TreeViewerConfiguration;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.services.spi.IContextualServiceRegistryTracker;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.emf.internal.facet.BadTreeViewerConfigurationException;
import org.eclipse.papyrus.infra.ui.emf.internal.facet.WorskpaceCustomizationUpdater;
import org.eclipse.papyrus.infra.ui.internal.emf.Activator;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class ArchitectureFrameworkCustomizationManagerUpdater
extends WorskpaceCustomizationUpdater {
    public static final ArchitectureFrameworkCustomizationManagerUpdater INSTANCE = new ArchitectureFrameworkCustomizationManagerUpdater();
    private final IPartListener papyrusEditorListener = new PapyrusEditorListener();
    private final Map<String, Customization> CUSTOMIZATION_MAP;

    private ArchitectureFrameworkCustomizationManagerUpdater() {
        this.registerPapyrusEditorListener();
        this.CUSTOMIZATION_MAP = new HashMap<String, Customization>();
        this.initMap();
    }

    private void registerPapyrusEditorListener() {
        IWorkbenchWindow ww = EditorHelper.getActiveWindow();
        if (ww != null && ww.getPartService() != null) {
            ww.getPartService().addPartListener(this.papyrusEditorListener);
        } else {
            Activator.log.warn("We are not able to get the PartService to register the papyrus editor listener");
        }
    }

    private void initMap() {
        ICustomizationManager customizationManager = Activator.getDefault().getCustomizationManager();
        ICustomizationCatalogManager customCatalog = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(customizationManager.getResourceSet());
        for (Customization current : customCatalog.getRegisteredCustomizations()) {
            this.CUSTOMIZATION_MAP.put(current.getName(), current);
        }
    }

    @Override
    public void applyCustomizations() {
        if (this.getEditedModelSet() != null) {
            if (this.hasCustomizationPreferences()) {
                this.applyCustomizationFromUserPreferences();
            } else {
                List<Customization> customizationsToApply;
                try {
                    customizationsToApply = this.getCustomizationsFromArchitectureFramework();
                }
                catch (BadTreeViewerConfigurationException e) {
                    Activator.log.error(e.getMessage(), (Throwable)e);
                    this.applyCustomizations(e.getIntermediateResult());
                    return;
                }
                if (customizationsToApply.size() > 0) {
                    this.applyCustomizations(customizationsToApply);
                } else {
                    super.applyCustomizations();
                }
            }
        }
    }

    @Override
    protected IDialogSettings getBrowserCustomizationDialogSettings() {
        return this.getModelSetBrowserCustomizationDialogSettings();
    }

    protected final IDialogSettings getModelSetBrowserCustomizationDialogSettings() {
        IDialogSettings settings = super.getWorkspaceBrowserCustomizationDialogSettings();
        if (settings != null) {
            ModelSet modelSet = this.getEditedModelSet();
            return settings.getSection(modelSet.getURIWithoutExtension().toString());
        }
        return null;
    }

    @Override
    protected IDialogSettings getOrCreateBrowserCustomizationDialogSettings() {
        return this.getOrCreateModelSetBrowserCustomizationDialogSettings();
    }

    protected final IDialogSettings getOrCreateModelSetBrowserCustomizationDialogSettings() {
        ModelSet modelSet;
        String modelKey;
        IDialogSettings settings = this.getOrCreateWorkspaceBrowserCustomizationDialogSettings();
        if (settings.getSection(modelKey = (modelSet = this.getEditedModelSet()).getURIWithoutExtension().toString()) == null) {
            settings = settings.addNewSection(modelKey);
            String loadedFacetPreferences = Activator.getDefault().getPreferenceStore().getString("defaultLoadedFacet");
            if (loadedFacetPreferences != null && !"".equals(loadedFacetPreferences)) {
                settings.put("org.eclipse.papyrus.infra.ui.emf.facet.order", loadedFacetPreferences.split(","));
            }
        }
        return settings;
    }

    @Override
    public void saveUserCustomizationsState() {
        if (this.getEditedModelSet() != null) {
            super.saveUserCustomizationsState();
        } else {
            Activator.log.warn("There is no active editor, the applied Customizations won't be saved");
        }
    }

    private final Collection<EMFFacetTreeViewerConfiguration> getEMFFacetConfiguration() {
        return this.getMergedTreeViewerConfiguration().stream().filter(EMFFacetTreeViewerConfiguration.class::isInstance).map(EMFFacetTreeViewerConfiguration.class::cast).collect(Collectors.toList());
    }

    private final List<Customization> getCustomizationsFromArchitectureFramework() throws BadTreeViewerConfigurationException {
        Collection<EMFFacetTreeViewerConfiguration> confs = this.getEMFFacetConfiguration();
        if (confs != null && confs.isEmpty()) {
            return Collections.emptyList();
        }
        ICustomizationReferenceMerger merger = CustomizationFacetFactory.getCustomizationReferenceMerger(confs);
        boolean isValid = merger.doValidationAndMerge();
        ArrayList<Customization> realResult = new ArrayList<Customization>(merger.getMergedCustomizations().size());
        for (Customization tmp : merger.getMergedCustomizations()) {
            Customization equivalentCusto = this.CUSTOMIZATION_MAP.get(tmp.getName());
            if (equivalentCusto == null) continue;
            realResult.add(equivalentCusto);
        }
        if (!isValid) {
            StringBuilder builder = new StringBuilder();
            builder.append(NLS.bind((String)"{0} defined in the current {1} are invalid", (Object)CustomizationConfigurationPackage.eINSTANCE.getEMFFacetTreeViewerConfiguration().getName(), (Object)ArchitecturePackage.eINSTANCE.getArchitectureDescriptionLanguage().getName()));
            for (Map.Entry current : merger.getStatus().entrySet()) {
                builder.append(NLS.bind((String)"\t\t{0} has the error {1}", (Object)((EObject)current.getKey()).toString(), (Object)((IStatus)current.getValue()).toString()));
            }
            throw new BadTreeViewerConfigurationException(builder.toString(), realResult);
        }
        return realResult;
    }

    protected final ModelSet getEditedModelSet() {
        ServicesRegistry servReg = this.getServiceRegistry();
        if (servReg != null) {
            try {
                return (ModelSet)servReg.getService(ModelSet.class);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return null;
    }

    protected final ServicesRegistry getServiceRegistry() {
        IContextualServiceRegistryTracker tracker = org.eclipse.papyrus.infra.core.Activator.getDefault().getContextualServiceRegistryTracker();
        if (tracker != null) {
            return tracker.getServiceRegistry();
        }
        return null;
    }

    @Override
    protected void destroyUserPreferences() {
        DialogSettings settings;
        ModelSet modelSet = this.getEditedModelSet();
        if (modelSet == null) {
            Activator.log.warn("There is no active editor, the applied Customizations won't be reset");
        }
        if ((settings = (DialogSettings)super.getBrowserCustomizationDialogSettings()) != null) {
            settings.removeSection(modelSet.getURIWithoutExtension().toString());
        }
    }

    protected final Collection<TreeViewerConfiguration> getMergedTreeViewerConfiguration() {
        ArchitectureDescriptionUtils adUtils;
        MergedArchitectureContext ctx;
        ModelSet modelSet = this.getEditedModelSet();
        if (modelSet != null && (ctx = (adUtils = new ArchitectureDescriptionUtils(modelSet)).getArchitectureContext()) instanceof MergedArchitectureDescriptionLanguage) {
            return ((MergedArchitectureDescriptionLanguage)ctx).getTreeViewerConfigurations();
        }
        return Collections.emptyList();
    }

    private final class PapyrusEditorListener
    implements IPartListener {
        private PapyrusEditorListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IMultiDiagramEditor) {
                INSTANCE.applyCustomizations();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

