/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.IControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.commands.BasicControlCommand;
import org.eclipse.papyrus.infra.services.controlmode.commands.BasicUncontrolCommand;
import org.eclipse.papyrus.infra.services.controlmode.commands.CreateControlResource;
import org.eclipse.papyrus.infra.services.controlmode.commands.RemoveControlResourceCommand;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandApprover;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlModeParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IShardModeCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;

public class ControlModeManager
implements IControlModeManager {
    private static final String CONTROL_COMMAND_POST_COMMANDS = Messages.getString("ControlModeManager.post.commands.label");
    private static final String CONTROL_COMMAND_PRE_COMMAND_TITLE = Messages.getString("ControlModeManager.pre.commands.label");
    private static final String CONTROL_COMMAND_TITLE = Messages.getString("ControlModeManager.control.command.parent.title");
    private static final String UNCONTROL_COMMAND_PRE_COMMAND_TITLE = Messages.getString("ControlModeManager.uncontrol.command.pre.title");
    private static final String UNCONTROL_COMMAND_POST_COMMANDS = Messages.getString("ControlModeManager.uncontrol.command.post.title");
    private static final String UNCONTROL_COMMAND_PARENT_TITLE = Messages.getString("ControlModeManager.uncontrol.command.parent.title");
    protected static String EXTENSION_ID = "org.eclipse.papyrus.infra.services.controlmode.participant";
    protected static String PARTICPANT_ATTRIBUTE = "class";
    protected ArrayList<IControlCommandParticipant> controlCommandParticipants = new ArrayList();
    protected ArrayList<IUncontrolCommandParticipant> uncontrolCommandParticipants = new ArrayList();
    protected List<IShardModeCommandParticipant> shardModeCommandParticipants = new ArrayList<IShardModeCommandParticipant>();
    protected List<IControlCommandApprover> controlCommandApprovers = new ArrayList<IControlCommandApprover>();

    public static IControlModeManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public ControlModeManager() {
        this.initParticipants();
    }

    @Override
    public ICommand getControlCommand(ControlModeRequest request) {
        boolean isOK = this.verifCorrectCommand(request);
        if (!isOK) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(request.getEditingDomain(), CONTROL_COMMAND_TITLE);
        ICompositeCommand preCommand = this.getPreCommand(request);
        if (preCommand != null && !preCommand.isEmpty()) {
            cc.compose((IUndoableOperation)preCommand);
        }
        cc.compose((IUndoableOperation)new CreateControlResource(request));
        cc.compose((IUndoableOperation)new BasicControlCommand(request));
        ICompositeCommand postCommand = this.getPostCommand(request);
        if (postCommand != null && !postCommand.isEmpty()) {
            cc.compose((IUndoableOperation)postCommand);
        }
        return cc;
    }

    protected boolean verifCorrectCommand(ControlModeRequest request) {
        EObject container;
        EObject objectToControl = request.getTargetObject();
        return objectToControl != null && (container = objectToControl.eContainer()) != null;
    }

    protected List<IControlCommandParticipant> getControlCommandParticipants() {
        return this.controlCommandParticipants;
    }

    protected ICompositeCommand getPostCommand(ControlModeRequest request) {
        boolean isControlRequest = request.isControlRequest();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(request.getEditingDomain(), isControlRequest ? CONTROL_COMMAND_POST_COMMANDS : UNCONTROL_COMMAND_POST_COMMANDS);
        if (isControlRequest) {
            this.getPostControlCommand(request, cc);
        } else {
            this.getPostUncontrolMethod(request, cc);
        }
        return cc;
    }

    protected void getPostControlCommand(ControlModeRequest request, CompositeTransactionalCommand cc) {
        ListIterator<IControlCommandParticipant> participantIterator = this.getControlCommandParticipants().listIterator(this.getControlCommandParticipants().size());
        while (participantIterator.hasPrevious()) {
            ICommand cmd;
            IControlCommandParticipant iControlCommandParticipant = participantIterator.previous();
            if (!iControlCommandParticipant.provideControlCommand(request) || (cmd = iControlCommandParticipant.getPostControlCommand(request)) == null) continue;
            cc.compose((IUndoableOperation)cmd);
        }
    }

    protected void getPostUncontrolMethod(ControlModeRequest request, CompositeTransactionalCommand cc) {
        ListIterator<IUncontrolCommandParticipant> participantIterator = this.getUncontrolCommandParticipants().listIterator(this.getUncontrolCommandParticipants().size());
        while (participantIterator.hasPrevious()) {
            ICommand cmd;
            IUncontrolCommandParticipant iControlCommandParticipant = participantIterator.previous();
            if (!iControlCommandParticipant.provideUnControlCommand(request) || (cmd = iControlCommandParticipant.getPostUncontrolCommand(request)) == null) continue;
            cc.compose((IUndoableOperation)cmd);
        }
    }

    protected ICompositeCommand getPreCommand(ControlModeRequest request) {
        boolean isControlRequest = request.isControlRequest();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(request.getEditingDomain(), isControlRequest ? CONTROL_COMMAND_PRE_COMMAND_TITLE : UNCONTROL_COMMAND_PRE_COMMAND_TITLE);
        if (isControlRequest) {
            this.getPreControlCommand(request, cc);
        } else {
            this.getPreUncontrolCommand(request, cc);
        }
        return cc;
    }

    protected void getPreControlCommand(ControlModeRequest request, CompositeTransactionalCommand cc) {
        for (IControlCommandParticipant iControlCommandParticipant : this.getControlCommandParticipants()) {
            ICommand cmd;
            if (!iControlCommandParticipant.provideControlCommand(request) || (cmd = iControlCommandParticipant.getPreControlCommand(request)) == null) continue;
            cc.compose((IUndoableOperation)cmd);
        }
    }

    protected void getPreUncontrolCommand(ControlModeRequest request, CompositeTransactionalCommand cc) {
        for (IUncontrolCommandParticipant iControlCommandParticipant : this.getUncontrolCommandParticipants()) {
            ICommand cmd;
            if (!iControlCommandParticipant.provideUnControlCommand(request) || (cmd = iControlCommandParticipant.getPreUncontrolCommand(request)) == null) continue;
            cc.compose((IUndoableOperation)cmd);
        }
    }

    @Override
    public ICommand getUncontrolCommand(ControlModeRequest request) {
        boolean isOK = this.verifCorrectCommand(request);
        if (!isOK) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(request.getEditingDomain(), UNCONTROL_COMMAND_PARENT_TITLE);
        ICompositeCommand preCommand = this.getPreCommand(request);
        if (preCommand != null && !preCommand.isEmpty()) {
            cc.compose((IUndoableOperation)preCommand);
        }
        cc.compose((IUndoableOperation)new BasicUncontrolCommand(request));
        cc.compose((IUndoableOperation)new RemoveControlResourceCommand(request));
        ICompositeCommand postCommand = this.getPostCommand(request);
        if (postCommand != null && !postCommand.isEmpty()) {
            cc.compose((IUndoableOperation)postCommand);
        }
        return cc;
    }

    protected List<IUncontrolCommandParticipant> getUncontrolCommandParticipants() {
        return this.uncontrolCommandParticipants;
    }

    protected List<IShardModeCommandParticipant> getShardModeCommandParticipants() {
        return this.shardModeCommandParticipants;
    }

    @Override
    public ICommand getShardModeCommand(ControlModeRequest request) {
        ICommand baseCommand = IControlModeManager.super.getShardModeCommand(request);
        CompositeTransactionalCommand result = new CompositeTransactionalCommand(request.getEditingDomain(), Messages.getString("ControlModeManager.changeControlModeCommand.label"));
        ICommand preCommand = this.getPreShardModeCommand(request);
        if (preCommand != null) {
            result = result.compose((IUndoableOperation)preCommand);
        }
        result = result.compose((IUndoableOperation)baseCommand);
        ICommand postCommand = this.getPostShardModeCommand(request);
        if (postCommand != null) {
            result = result.compose((IUndoableOperation)postCommand);
        }
        return result.reduce();
    }

    protected ICommand getPreShardModeCommand(ControlModeRequest request) {
        return this.getParticipantCommand(request, this.getShardModeCommandParticipants(), IShardModeCommandParticipant::providesShardModeCommand, IShardModeCommandParticipant::getPreShardModeCommand);
    }

    protected ICommand getPostShardModeCommand(ControlModeRequest request) {
        return this.getParticipantCommand(request, this.getShardModeCommandParticipants(), IShardModeCommandParticipant::providesShardModeCommand, IShardModeCommandParticipant::getPostShardModeCommand);
    }

    private <P extends IControlModeParticipant> ICommand getParticipantCommand(ControlModeRequest request, Collection<? extends P> participants, BiPredicate<? super P, ? super ControlModeRequest> filter, BiFunction<? super P, ? super ControlModeRequest, ICommand> commandFunction) {
        return participants.stream().filter(p -> filter.test((Object)p, request)).map(p -> (ICommand)commandFunction.apply((Object)p, request)).filter(Objects::nonNull).reduce(ICommand::compose).orElse(null);
    }

    @Override
    public Diagnostic approveRequest(ControlModeRequest request) {
        List<IControlCommandApprover> approvers = this.getControlCommandApprovers();
        Diagnostic result = approvers.isEmpty() ? Diagnostic.OK_INSTANCE : approvers.stream().map(a -> a.approveRequest(request)).filter(Objects::nonNull).reduce(Diagnostic.OK_INSTANCE, this::merge);
        return result;
    }

    private Diagnostic merge(Diagnostic a, Diagnostic b) {
        return a.getSeverity() == 0 ? b : (b.getSeverity() == 0 ? a : (Diagnostic)this.merge(new BasicDiagnostic(a.getSource(), a.getCode(), a.getMessage(), null), a, b));
    }

    private <D extends DiagnosticChain> D merge(D chain, Diagnostic a, Diagnostic b) {
        chain.merge(a);
        chain.merge(b);
        return chain;
    }

    @Override
    public boolean canCreateSubmodel(EObject objectToControl) {
        List<IControlCommandApprover> approvers = this.getControlCommandApprovers();
        return approvers.isEmpty() || approvers.stream().allMatch(a -> a.canCreateSubModel(objectToControl));
    }

    protected List<IControlCommandApprover> getControlCommandApprovers() {
        return this.controlCommandApprovers;
    }

    protected void initParticipants() {
        IConfigurationElement[] extensions;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object particpant = e.createExecutableExtension(PARTICPANT_ATTRIBUTE);
                if (particpant instanceof IControlCommandParticipant) {
                    this.getControlCommandParticipants().add((IControlCommandParticipant)particpant);
                }
                if (particpant instanceof IUncontrolCommandParticipant) {
                    this.getUncontrolCommandParticipants().add((IUncontrolCommandParticipant)particpant);
                }
                if (particpant instanceof IShardModeCommandParticipant) {
                    this.getShardModeCommandParticipants().add((IShardModeCommandParticipant)particpant);
                }
                if (particpant instanceof IControlCommandApprover) {
                    this.getControlCommandApprovers().add((IControlCommandApprover)particpant);
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        PartipantComparator comparator = new PartipantComparator();
        Collections.sort(this.uncontrolCommandParticipants, comparator);
        Collections.sort(this.controlCommandParticipants, comparator);
        Collections.sort(this.shardModeCommandParticipants, comparator);
        Collections.sort(this.controlCommandApprovers, comparator);
    }

    protected final class PartipantComparator
    implements Comparator<IControlModeParticipant> {
        protected PartipantComparator() {
        }

        @Override
        public int compare(IControlModeParticipant arg0, IControlModeParticipant arg1) {
            int j;
            int i = arg1.getPriority();
            return i >= (j = arg0.getPriority()) ? (i != j ? 1 : 0) : -1;
        }
    }

    private static class SingletonHolder {
        private static ControlModeManager INSTANCE = new ControlModeManager();

        private SingletonHolder() {
        }
    }
}

