/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.infra.ui.architecture.ArchitectureUIPlugin;

public class ResolveAllAction
extends Action
implements ISelectionChangedListener {
    protected ISelectionProvider selectionProvider;
    protected List<EObject> selectedObjects;

    public ResolveAllAction() {
        super(ArchitectureUIPlugin.INSTANCE.getString("_UI_Resolve_All_menu_item"));
        this.setDescription(ArchitectureUIPlugin.INSTANCE.getString("_UI_Resolve_All_simple_description"));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionProvider = event.getSelectionProvider();
        if (event.getSelection() instanceof IStructuredSelection) {
            this.setEnabled(this.updateSelection((IStructuredSelection)event.getSelection()));
        } else {
            this.setEnabled(false);
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.selectedObjects = new ArrayList<EObject>();
        Iterator objects = selection.iterator();
        while (objects.hasNext()) {
            Object object = AdapterFactoryEditingDomain.unwrap(objects.next());
            if (object instanceof EObject) {
                this.selectedObjects.add((EObject)object);
                continue;
            }
            if (object instanceof Resource) {
                this.selectedObjects.addAll((Collection<EObject>)((Resource)object).getContents());
                continue;
            }
            return false;
        }
        this.selectedObjects = EcoreUtil.filterDescendants(this.selectedObjects);
        return !this.selectedObjects.isEmpty();
    }

    public void run() {
        for (EObject obj : this.selectedObjects) {
            EcoreUtil.resolveAll((EObject)obj);
        }
    }
}

