/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.stereotype.display.manager.cell;

import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.nattable.manager.cell.ICellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.CellHelper;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;
import org.eclipse.papyrus.uml.nattable.stereotype.display.utils.StereotypeDisplayTreeTableHelper;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeDisplayTreeTableCellManager
implements ICellManager {
    private StereotypeDisplayTreeTableHelper helper = StereotypeDisplayTreeTableHelper.getInstance();

    public boolean handles(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        boolean handles = false;
        Object element = AxisUtils.getRepresentedElement((Object)columnElement);
        if (element instanceof String) {
            handles = ((String)element).startsWith("stereotype_display_properties:/");
        }
        return handles;
    }

    public Object getValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        Object result;
        block19: {
            String shortElement;
            result = "";
            Object element = AxisUtils.getRepresentedElement((Object)columnElement);
            if (!(element instanceof String)) break block19;
            switch (shortElement = StereotypeDisplayTreeTableHelper.getInstance().getShortValue(element)) {
                case "nameDepth": {
                    result = this.helper.getDepthValue(rowElement);
                    break;
                }
                case "isDisplayed": {
                    result = this.helper.getDisplayedValue(rowElement);
                    break;
                }
                case "isDisplayedInBraces": {
                    result = this.helper.getBraceValue(rowElement);
                    break;
                }
                case "isDisplayedInComment": {
                    result = this.helper.getCommentValue(rowElement);
                    break;
                }
                case "isDisplayedInCompartment": {
                    result = this.helper.getCompartmentValue(rowElement);
                    break;
                }
            }
        }
        return result;
    }

    public void setValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        block19: {
            String shortElement;
            Object element = AxisUtils.getRepresentedElement((Object)columnElement);
            if (!(element instanceof String)) break block19;
            switch (shortElement = StereotypeDisplayTreeTableHelper.getInstance().getShortValue(element)) {
                case "nameDepth": {
                    this.helper.setDepthValue(domain, rowElement, newValue);
                    break;
                }
                case "isDisplayed": {
                    this.helper.setDisplayedValue(domain, rowElement, newValue);
                    break;
                }
                case "isDisplayedInBraces": {
                    this.helper.setBraceValue(domain, rowElement, newValue);
                    break;
                }
                case "isDisplayedInComment": {
                    this.helper.setCommentValue(domain, rowElement, newValue);
                    break;
                }
                case "isDisplayedInCompartment": {
                    this.helper.setCompartmentValue(domain, rowElement, newValue);
                    break;
                }
            }
        }
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        boolean result = true;
        Object column = AxisUtils.getRepresentedElement((Object)columnElement);
        if (column instanceof String) {
            Object row;
            String shortElement = StereotypeDisplayTreeTableHelper.getInstance().getShortValue(column);
            if ("isDisplayed".equals(shortElement) && (row = AxisUtils.getRepresentedElement((Object)rowElement)) instanceof Property) {
                result = false;
            }
            if ("nameDepth".equals(shortElement) && !((row = AxisUtils.getRepresentedElement((Object)rowElement)) instanceof Stereotype)) {
                result = false;
            }
        }
        return result;
    }

    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        return null;
    }

    public Command getSetStringValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, String newValue, AbstractStringValueConverter valueConverter, INattableModelManager tableManager) {
        return null;
    }

    public AbstractStringValueConverter getOrCreateStringValueConverterClass(Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters, String multiValueSeparator, INattableModelManager tableManager) {
        return null;
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, Map<?, ?> sharedMap, INattableModelManager tableManager) {
        return false;
    }

    public void setStringValue(Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter valueConverter, Map<?, ?> sharedMap, INattableModelManager tableManager) {
    }

    public String getUnsupportedCellContentsText() {
        return CellHelper.getUnsupportedCellContentsText();
    }
}

