/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.policies;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.ContainmentDragDropHelper;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLVisualIDRegistry;

public class CustomContainmentCreationEditPolicy
extends DefaultCreationEditPolicy {
    private static List<String> ourCanHaveContainmentLinks = Arrays.asList("Class_ClassNestedClassifierLabel", "Class_Shape_CN", "Package_Shape_CN", "Model_Shape_CN", "Model_Shape", "Class_Shape", "Package_Shape");

    protected Command getReparentCommand(ChangeBoundsRequest request) {
        Iterator editParts = request.getEditParts().iterator();
        View container = (View)this.getHost().getAdapter(View.class);
        EObject context = container == null ? null : ViewUtil.resolveSemanticElement((View)container);
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        while (editParts.hasNext()) {
            View view;
            EditPart ep = (EditPart)editParts.next();
            if (ep instanceof LabelEditPart) continue;
            if (ep instanceof GroupEditPart) {
                cc.compose((IUndoableOperation)this.getReparentGroupCommand((GroupEditPart)ep));
            }
            if ((view = (View)ep.getAdapter(View.class)) == null) continue;
            EObject semantic = ViewUtil.resolveSemanticElement((View)view);
            if (semantic == null) {
                cc.compose((IUndoableOperation)this.getReparentViewCommand((IGraphicalEditPart)ep));
            } else if (context != null && this.hasContainmentLink(view)) {
                View hostView = (View)this.getHost().getModel();
                View movedView = (View)ep.getModel();
                Command customCommand = new ContainmentDragDropHelper(((IGraphicalEditPart)ep).getEditingDomain()).getDropWithContainmentCommand(hostView, movedView);
                if (customCommand != null) {
                    return customCommand;
                }
            }
            if (semantic == null || context == null || !this.shouldReparent(semantic, context)) continue;
            cc.compose((IUndoableOperation)this.getReparentCommand((IGraphicalEditPart)ep));
        }
        return cc.isEmpty() ? null : new ICommandProxy(cc.reduce());
    }

    private boolean hasContainmentLink(View movedView) {
        return ourCanHaveContainmentLinks.contains(UMLVisualIDRegistry.getVisualID(movedView));
    }
}

