/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler;

import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.AbstractStyleDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.AbstractStyleHandler;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.StyleCreationDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.helper.XtextStylesheetHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.AttributeSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CSSFactory;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_declaration;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ruleset;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.stylesheet;
import org.eclipse.swt.widgets.Shell;

public class CreateStyleHandler
extends AbstractStyleHandler {
    @Override
    protected AbstractStyleDialog createStyleDialog(Shell shell, Map<css_declaration, Boolean> declarations, Map<AttributeSelector, Boolean> conditions, String selectorName, View context) {
        return new StyleCreationDialog(shell, conditions, declarations, selectorName, context);
    }

    @Override
    protected ruleset getRuleset(AbstractStyleDialog dialog) {
        return CSSFactory.eINSTANCE.createruleset();
    }

    @Override
    protected stylesheet getStyleSheet(AbstractStyleDialog dialog, View contextView) {
        stylesheet xtextStylesheet;
        Resource resource;
        StyleSheet styleSheet = ((StyleCreationDialog)dialog).getStyleSheet();
        if (styleSheet == null) {
            MessageDialog.open((int)1, (Shell)dialog.getShell(), (String)"Stylesheet error", (String)"Invalid stylesheet", (int)0);
            return null;
        }
        if (styleSheet instanceof StyleSheetReference) {
            resource = XtextStylesheetHelper.loadStylesheet((StyleSheetReference)styleSheet, null, contextView, dialog.getShell());
            if (resource == null) {
                return null;
            }
        } else {
            MessageDialog.open((int)1, (Shell)dialog.getShell(), (String)"Stylesheet error", (String)"Embedded stylesheets are not yet supported", (int)0);
            return null;
        }
        if (resource.getContents().isEmpty()) {
            xtextStylesheet = CSSFactory.eINSTANCE.createstylesheet();
            this.setCharset(xtextStylesheet, "UTF-8");
            resource.getContents().add((Object)xtextStylesheet);
        } else {
            xtextStylesheet = (stylesheet)resource.getContents().get(0);
        }
        return xtextStylesheet;
    }
}

