/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.snap.ResizeTrackerWithPreferences;

public class PapyrusResizableShapeEditPolicy
extends ResizableShapeEditPolicy {
    private static final String PARAM_CACHED_EDIT_PARTS_SET = String.valueOf(PapyrusResizableShapeEditPolicy.class.getName()) + ":CachedMovedEPs";

    protected static CachedEditPartsSet getMovedEditPartsSet(ChangeBoundsRequest req) {
        Map extData = req.getExtendedData();
        CachedEditPartsSet set = (CachedEditPartsSet)extData.get(PARAM_CACHED_EDIT_PARTS_SET);
        if (set == null) {
            set = new CachedEditPartsSet(req.getEditParts());
            extData.put(PARAM_CACHED_EDIT_PARTS_SET, set);
        }
        return set;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move children");
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        HashMap<String, CachedEditPartsSet> extendedData = new HashMap<String, CachedEditPartsSet>();
        extendedData.putAll(request.getExtendedData());
        CachedEditPartsSet set = new CachedEditPartsSet(request.getEditParts());
        extendedData.put(PARAM_CACHED_EDIT_PARTS_SET, set);
        req.setExtendedData(extendedData);
        return this.getHost().getParent().getCommand((Request)req);
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setCenteredResize(request.isCenteredResize());
        req.setConstrainedMove(request.isConstrainedMove());
        req.setConstrainedResize(request.isConstrainedResize());
        req.setSnapToEnabled(request.isSnapToEnabled());
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        req.setResizeDirection(request.getResizeDirection());
        if (this.getHost().getParent() == null) {
            return null;
        }
        return this.getHost().getParent().getCommand((Request)req);
    }

    protected ResizeTracker getResizeTracker(int direction) {
        return new ResizeTrackerWithPreferences((GraphicalEditPart)this.getHost(), direction);
    }

    protected static class CachedEditPartsSet {
        private final Set<EditPart> myDirectlyMoved;
        private final Set<EditPart> myKnownIndirectlyYes;
        private final Set<EditPart> myKnownIndirectlyNo;

        public CachedEditPartsSet(List<EditPart> directlyMoved) {
            this.myDirectlyMoved = new HashSet<EditPart>(directlyMoved);
            this.myKnownIndirectlyNo = new HashSet<EditPart>(directlyMoved.size() * 5 + 1);
            this.myKnownIndirectlyYes = new HashSet<EditPart>(directlyMoved.size() * 5 + 1);
        }

        public boolean isMovedEditPart(EditPart ep) {
            return this.isMoved(ep) != MovedNodeKind.NO;
        }

        public MovedNodeKind isMoved(EditPart ep) {
            Set<EditPart> forKind;
            LinkedList<EditPart> chainUp = new LinkedList<EditPart>();
            EditPart cur = ep;
            MovedNodeKind kind = null;
            while (cur != null) {
                kind = this.getKnownKind(cur);
                if (kind != null) break;
                chainUp.add(cur);
                cur = cur.getParent();
            }
            if (cur == null || kind == null) {
                kind = MovedNodeKind.NO;
            } else if (kind == MovedNodeKind.DIRECTLY && cur != ep) {
                kind = MovedNodeKind.INDIRECTLY;
            }
            switch (kind) {
                case DIRECTLY: {
                    forKind = this.myDirectlyMoved;
                    break;
                }
                case INDIRECTLY: {
                    forKind = this.myKnownIndirectlyYes;
                    break;
                }
                case NO: {
                    forKind = this.myKnownIndirectlyNo;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wow: " + (Object)((Object)kind));
                }
            }
            if (kind != MovedNodeKind.DIRECTLY) {
                forKind.addAll(chainUp);
            }
            return kind;
        }

        private MovedNodeKind getKnownKind(EditPart ep) {
            if (this.myDirectlyMoved.contains(ep)) {
                return MovedNodeKind.DIRECTLY;
            }
            if (this.myKnownIndirectlyYes.contains(ep)) {
                return MovedNodeKind.INDIRECTLY;
            }
            if (this.myKnownIndirectlyNo.contains(ep)) {
                return MovedNodeKind.NO;
            }
            return null;
        }
    }

    protected static enum MovedNodeKind {
        DIRECTLY,
        INDIRECTLY,
        NO;

    }
}

