/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.internal.resource.index;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.internal.resource.index.IIndexSaveParticipant;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndex;

public class IndexPersistenceManager {
    private static final IPath INDEX_DIR = new Path("index").addTrailingSeparator();
    private static final String ZIP_ENTRY = "Contents";
    public static final IndexPersistenceManager INSTANCE = new IndexPersistenceManager();
    private final Map<WorkspaceModelIndex<?>, IIndexSaveParticipant> workspaceIndices = Maps.newConcurrentMap();
    private Map<String, IPath> indexFiles = Collections.emptyMap();

    private IndexPersistenceManager() {
    }

    public void initialize(ISavedState state) throws CoreException {
        this.indexFiles = Collections.unmodifiableMap(Stream.of(state.getFiles()).collect(Collectors.toMap(IPath::toString, arg_0 -> ((ISavedState)state).lookup(arg_0))));
    }

    public InputStream addIndex(WorkspaceModelIndex<?> index, IIndexSaveParticipant saveParticipant) {
        File storeFile;
        ZipInputStream result = null;
        this.workspaceIndices.put(index, saveParticipant);
        IPath indexFile = this.indexFiles.get(index.getName());
        File file = storeFile = indexFile != null ? this.getStoreFile(indexFile) : null;
        if (storeFile != null && storeFile.exists()) {
            try {
                result = new ZipInputStream(new FileInputStream(storeFile));
                result.getNextEntry();
            }
            catch (Exception e) {
                Activator.log.error("Failed to open index file for " + index.getName(), (Throwable)e);
            }
        }
        return result;
    }

    public void removeIndex(WorkspaceModelIndex<?> index) {
        this.workspaceIndices.remove(index);
    }

    private IPath getIndexLocation() {
        return Activator.getDefault().getStateLocation().append(INDEX_DIR);
    }

    private File getStoreFile(IPath storePath) {
        return Activator.getDefault().getStateLocation().append(storePath).toFile();
    }

    private IPath getStorePath(WorkspaceModelIndex<?> index, int saveNumber) {
        return INDEX_DIR.append(index.getName()).addFileExtension(String.valueOf(saveNumber));
    }

    private IPath getStoreLocation(WorkspaceModelIndex<?> index, int saveNumber) {
        return Activator.getDefault().getStateLocation().append(this.getStorePath(index, saveNumber));
    }

    public ISaveParticipant getSaveParticipant() {
        return new ISaveParticipant(){
            private Map<String, IPath> newIndexFiles;

            public void prepareToSave(ISaveContext context) throws CoreException {
                File indexDirectory = IndexPersistenceManager.this.getIndexLocation().toFile();
                if (!indexDirectory.exists()) {
                    indexDirectory.mkdir();
                }
            }

            public void saving(ISaveContext context) throws CoreException {
                for (Map.Entry entry : IndexPersistenceManager.this.workspaceIndices.entrySet()) {
                    WorkspaceModelIndex index2 = (WorkspaceModelIndex)entry.getKey();
                    IIndexSaveParticipant save = (IIndexSaveParticipant)entry.getValue();
                    if (save == null) continue;
                    File storeFile = IndexPersistenceManager.this.getStoreLocation(index2, context.getSaveNumber()).toFile();
                    try {
                        Throwable throwable = null;
                        Object var8_14 = null;
                        try (OutputStream store = this.createStoreOutput(storeFile);){
                            save.save(index2, store);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        storeFile.delete();
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.emf", "Failed to save index " + index2.getName(), (Throwable)e));
                    }
                }
                this.newIndexFiles = IndexPersistenceManager.this.workspaceIndices.keySet().stream().collect(Collectors.toMap(WorkspaceModelIndex::getName, index -> IndexPersistenceManager.this.getStorePath(index, context.getSaveNumber())));
                for (String string : IndexPersistenceManager.this.indexFiles.keySet()) {
                    context.map((IPath)new Path(string), null);
                }
                for (Map.Entry<Object, Object> entry : this.newIndexFiles.entrySet()) {
                    context.map((IPath)new Path((String)entry.getKey()), (IPath)entry.getValue());
                }
            }

            private OutputStream createStoreOutput(File storeFile) throws IOException {
                ZipOutputStream result = new ZipOutputStream(new FileOutputStream(storeFile));
                ZipEntry entry = new ZipEntry(IndexPersistenceManager.ZIP_ENTRY);
                result.putNextEntry(entry);
                return result;
            }

            public void doneSaving(ISaveContext context) {
                try {
                    IndexPersistenceManager.this.indexFiles.values().forEach(p -> {
                        boolean bl = IndexPersistenceManager.this.getStoreFile(p).delete();
                    });
                }
                catch (Exception e) {
                    Activator.log.error("Failed to clean up old index files", (Throwable)e);
                }
                IndexPersistenceManager.this.indexFiles = this.newIndexFiles;
                this.newIndexFiles = null;
            }

            public void rollback(ISaveContext context) {
                try {
                    if (this.newIndexFiles != null) {
                        this.newIndexFiles.values().stream().map(arg_0 -> IndexPersistenceManager.access$5(IndexPersistenceManager.this, arg_0)).forEach(File::delete);
                        this.newIndexFiles.keySet().stream().map(Path::new).forEach(p -> context.map((IPath)p, null));
                        this.newIndexFiles = null;
                        IndexPersistenceManager.this.indexFiles.forEach((name, location) -> context.map((IPath)new Path(name), location));
                    }
                }
                catch (Exception e) {
                    Activator.log.error("Failed to roll back model indices.", (Throwable)e);
                }
            }
        };
    }
}

