/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.infra.nattable.dialog.PasteImportStatusDialog;
import org.eclipse.papyrus.infra.nattable.manager.AbstractPasteImportInsertInNattableManager;
import org.eclipse.papyrus.infra.nattable.manager.InsertInNattableManager;
import org.eclipse.papyrus.infra.nattable.manager.PasteAxisInNattableManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.TableClipboardUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PasteInsertUtil {
    private static final boolean useProgressMonitorDialog = true;

    public static Object paste(INattableModelManager currentNattableModelManager, ISelection currentSelection, Map<Object, Object> parameters) {
        return PasteInsertUtil.doAction(currentNattableModelManager, currentSelection, parameters, true);
    }

    public static Object insert(INattableModelManager currentNattableModelManager, ISelection currentSelection, Map<Object, Object> parameters) {
        return PasteInsertUtil.doAction(currentNattableModelManager, currentSelection, parameters, false);
    }

    protected static Object doAction(INattableModelManager currentNattableModelManager, ISelection currentSelection, Map<Object, Object> parameters, boolean isPaste) {
        Object res;
        CSVPasteHelper pasteHelper = new CSVPasteHelper();
        boolean openProgressMonitor = true;
        Object value = parameters.get("openProgressMonitorDialog");
        if (value instanceof Boolean) {
            openProgressMonitor = (Boolean)value;
        }
        TableSelectionWrapper tableSelectionWrapper = null;
        if (currentSelection instanceof TableStructuredSelection && (tableSelectionWrapper = (TableSelectionWrapper)((TableStructuredSelection)currentSelection).getAdapter(TableSelectionWrapper.class)).getSelectedCells().isEmpty()) {
            tableSelectionWrapper = null;
        }
        boolean openDialog = (res = parameters.get("openDialogOnFail")) == null || Boolean.TRUE.equals(res);
        Object userAction = parameters.get("preferredUserAction");
        int preferredUserAction = userAction == null ? -1 : Integer.parseInt(userAction.toString());
        Object textToPaste = parameters.get("textToPaste");
        String clipboardContentsAsString = textToPaste != null ? (String)textToPaste : TableClipboardUtils.getClipboardContentsAsString();
        Status result = null;
        if (clipboardContentsAsString != null && !clipboardContentsAsString.isEmpty()) {
            AbstractPasteImportInsertInNattableManager pasteManager = null;
            pasteManager = isPaste ? new PasteAxisInNattableManager(currentNattableModelManager, pasteHelper, openProgressMonitor, openDialog, preferredUserAction, tableSelectionWrapper, clipboardContentsAsString) : new InsertInNattableManager(currentNattableModelManager, pasteHelper, openProgressMonitor, openDialog, preferredUserAction, tableSelectionWrapper, clipboardContentsAsString);
            result = pasteManager.doAction();
        } else {
            result = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.PasteImportHandler_EmptyClipboardString);
        }
        if (openDialog) {
            PasteInsertUtil.displayDialog((IStatus)result);
        }
        return result;
    }

    protected static void displayDialog(IStatus result) {
        if (result != null) {
            if (PasteInsertUtil.isPasteConfigurationStatus(result)) {
                new PasteImportStatusDialog(Display.getDefault().getActiveShell(), result).open();
            } else if (result.getSeverity() != 0) {
                String messageDialog = null;
                switch (result.getSeverity()) {
                    case 1: {
                        messageDialog = Messages.PasteInTableHandler_PasteInformation;
                        break;
                    }
                    case 2: {
                        messageDialog = Messages.PasteInTableHandler_PasteWarning;
                        break;
                    }
                    case 4: {
                        messageDialog = Messages.PasteInTableHandler_PasteError;
                        break;
                    }
                    case 8: {
                        messageDialog = Messages.PasteInTableHandler_PasteCancelled;
                    }
                }
                ErrorDialog errorDialog = new ErrorDialog(Display.getDefault().getActiveShell(), Messages.PasteImportStatusDialog_ImportPasteDialogTitle, messageDialog, result, 7){

                    protected void configureShell(Shell shell) {
                        super.configureShell(shell);
                        shell.setImage(Activator.getDefault().getImage("/icons/papyrus.png"));
                    }
                };
                errorDialog.open();
            }
        }
    }

    protected static boolean isPasteConfigurationStatus(IStatus status) {
        boolean result = false;
        switch (status.getSeverity()) {
            case 22: 
            case 50: 
            case 100: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }
}

