/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.dialog;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.enums.TreeTableAction;
import org.eclipse.papyrus.infra.nattable.export.image.ImageFormat;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class ExportTableDialog
extends Dialog {
    protected Composite dialogComposite = null;
    protected int filterIndex = -1;
    protected Text outputPathTxt = null;
    protected Button browseFileSystemBtn = null;
    protected Button browseWorkSpaceBtn = null;
    protected Text imageNameTxt = null;
    protected Combo outputFormatCb = null;
    protected Combo treeActionCb = null;
    protected IResource outputDirectory = null;
    protected String exportFormat = null;
    protected String selectedTreeAction = null;
    protected String defaultTableName = null;
    protected String[] defaultFilterExtensions = null;
    protected boolean isTreeTable = false;
    protected String exportedFileName = null;

    public ExportTableDialog(Shell parentShell, IResource defaultOutputDir, String defaultTableName, String[] defaultFilterExtensions, boolean isTreeTable) {
        super(parentShell);
        this.setBlockOnOpen(true);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.outputDirectory = defaultOutputDir;
        this.defaultTableName = defaultTableName;
        this.defaultFilterExtensions = defaultFilterExtensions;
        this.isTreeTable = isTreeTable;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ExportTableDialog_ExportTableDialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogComposite = (Composite)super.createDialogArea(parent);
        this.createDialogComposite();
        this.createDialogContents();
        return this.dialogComposite;
    }

    protected void createDialogComposite() {
        GridLayout dialogLayout = new GridLayout();
        GridData dialogLayoutData = new GridData(1808);
        this.dialogComposite.setLayout((Layout)dialogLayout);
        this.dialogComposite.setLayoutData((Object)dialogLayoutData);
    }

    protected void createDialogContents() {
        Composite composite = new Composite(this.dialogComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        composite.setFont(this.dialogComposite.getFont());
        composite.setLayoutData((Object)new GridData(1808));
        this.createOutputPathTextbox(composite);
        this.createBrowseWorkSpaceBtn(composite);
        this.createBrowseFileSystemBtn(composite);
        this.createImageNameTextbox(composite);
        this.createOutputFormatCombobox(composite);
        if (this.isTreeTable) {
            this.createTreeActionCombobox(composite);
        }
        this.computeExportedFileName();
    }

    protected void createOutputPathTextbox(Composite composite) {
        Label selectOutputDirLbl = new Label(composite, 0);
        selectOutputDirLbl.setText(Messages.ExportTableDialog_SelectOutputDirLabel);
        this.outputPathTxt = new Text(composite, 2048);
        this.outputPathTxt.setEnabled(false);
        this.outputPathTxt.setLayoutData((Object)new GridData(768));
        if (this.outputDirectory != null) {
            this.outputPathTxt.setText(this.outputDirectory.getLocation().toString());
        }
    }

    protected void createBrowseFileSystemBtn(Composite composite) {
        this.browseFileSystemBtn = new Button(composite, 0);
        this.browseFileSystemBtn.setText(Messages.ExportTableDialog_BrowseFileSystem);
        this.browseFileSystemBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(ExportTableDialog.this.getShell(), 0);
                String absolutePath = dirDialog.open();
                if (absolutePath != null && !absolutePath.isEmpty()) {
                    ExportTableDialog.this.outputPathTxt.setText(absolutePath);
                    ExportTableDialog.this.computeExportedFileName();
                }
            }
        });
    }

    protected void createBrowseWorkSpaceBtn(Composite composite) {
        this.browseWorkSpaceBtn = new Button(composite, 0);
        this.browseWorkSpaceBtn.setText(Messages.ExportTableDialog_BrowseWorkSpace);
        this.browseWorkSpaceBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] results;
                ContainerSelectionDialog csDialog = new ContainerSelectionDialog(Display.getCurrent().getActiveShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, Messages.ExportTableDialog_ContainerSelectionDialogTitle);
                if (csDialog.open() == 0 && 1 == (results = csDialog.getResult()).length && results[0] instanceof IPath) {
                    URI uri = URI.createPlatformResourceURI((String)((IPath)results[0]).toString(), (boolean)true);
                    ExportTableDialog.this.outputDirectory = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(uri.toPlatformString(true)));
                    ExportTableDialog.this.outputPathTxt.setText(ExportTableDialog.this.outputDirectory.getLocation().toString());
                    ExportTableDialog.this.computeExportedFileName();
                }
            }
        });
    }

    protected void createImageNameTextbox(Composite composite) {
        Label imageNameLbl = new Label(composite, 0);
        imageNameLbl.setText(Messages.ExportTableDialog_ImageNameLabel);
        this.imageNameTxt = new Text(composite, 2048);
        GridData imageNameTxtGridData = new GridData(768);
        imageNameTxtGridData.horizontalSpan = 3;
        this.imageNameTxt.setLayoutData((Object)imageNameTxtGridData);
        this.imageNameTxt.setText(this.defaultTableName);
        this.imageNameTxt.addModifyListener(new ModifyListener(){

            public final void modifyText(ModifyEvent event) {
                ExportTableDialog.this.computeExportedFileName();
            }
        });
    }

    protected void createOutputFormatCombobox(Composite composite) {
        Label outputFormatLbl = new Label(composite, 0);
        outputFormatLbl.setText(Messages.ExportTableDialog_SelectOutputFormatLabel);
        this.outputFormatCb = new Combo(composite, 0);
        GridData outputFormatCbGridData = new GridData(768);
        outputFormatCbGridData.horizontalSpan = 3;
        this.outputFormatCb.setLayoutData((Object)outputFormatCbGridData);
        String[] stringArray = this.defaultFilterExtensions;
        int n = this.defaultFilterExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String imageFileFormat = stringArray[n2];
            this.outputFormatCb.add(imageFileFormat);
            ++n2;
        }
        this.outputFormatCb.setText(ImageFormat.getDefaultImageExtension());
        this.exportFormat = this.outputFormatCb.getText();
        this.filterIndex = 0;
        this.outputFormatCb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportTableDialog.this.exportFormat = ExportTableDialog.this.outputFormatCb.getText();
                ExportTableDialog.this.filterIndex = ExportTableDialog.this.outputFormatCb.getSelectionIndex();
                ExportTableDialog.this.computeExportedFileName();
            }
        });
    }

    protected void createTreeActionCombobox(Composite composite) {
        Label selectTreeActionLbl = new Label(composite, 0);
        selectTreeActionLbl.setText(Messages.ExportTableDialog_SelectTreeActionLabel);
        this.treeActionCb = new Combo(composite, 0);
        GridData treeActionCbGridData = new GridData(768);
        treeActionCbGridData.horizontalSpan = 3;
        this.treeActionCb.setLayoutData((Object)treeActionCbGridData);
        TreeTableAction[] treeTableActionArray = TreeTableAction.VALUES;
        int n = TreeTableAction.VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            TreeTableAction action = treeTableActionArray[n2];
            this.treeActionCb.add(action.toString());
            ++n2;
        }
        this.treeActionCb.setText(TreeTableAction.getDefaultTableAction().toString());
        this.selectedTreeAction = this.treeActionCb.getText();
        this.treeActionCb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportTableDialog.this.selectedTreeAction = ExportTableDialog.this.treeActionCb.getText();
            }
        });
    }

    public String getSelectedTreeAction() {
        return this.selectedTreeAction;
    }

    public String getExportedFileName() {
        return this.exportedFileName;
    }

    protected void computeExportedFileName() {
        this.exportedFileName = String.valueOf(this.outputPathTxt.getText()) + File.separator + this.imageNameTxt.getText() + "." + this.exportFormat;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    protected void okPressed() {
        MessageDialog dialog;
        File file = new File(this.exportedFileName);
        if (file.exists() && (dialog = new MessageDialog(this.getShell(), Messages.ExportTableDialog_OverrideConfirmMessasgeDialogText, null, NLS.bind((String)Messages.ExportTableDialog_OverrideConfirmMessasgeDialogMessage, (Object)(String.valueOf(this.imageNameTxt.getText()) + "." + this.exportFormat)), 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0)).open() != 0) {
            return;
        }
        super.okPressed();
    }
}

