/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.part;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.expressions.UMLOCLFactory;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.timing/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public String getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public String getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, String candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(String visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(String visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static String getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLTimingDiagram".equals(view.getType())) {
                return "Package_TimingDiagram";
            }
            return "";
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static String getVisualID(String type) {
        return type;
    }

    public static String getType(String visualID) {
        return visualID;
    }

    public static String getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return "";
        }
        return "Package_TimingDiagram";
    }

    public static String getNodeVisualID(View containerView, EObject domainElement) {
        block42: {
            String containerVisualID;
            if (domainElement == null) {
                return "";
            }
            String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
            if (!"PapyrusUMLTimingDiagram".equals(containerModelID)) {
                return "";
            }
            if ("PapyrusUMLTimingDiagram".equals(containerModelID)) {
                containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
            } else if (containerView instanceof Diagram) {
                containerVisualID = "Package_TimingDiagram";
            } else {
                return "";
            }
            if (containerVisualID == null) break block42;
            switch (containerVisualID) {
                case "Package_TimingDiagram": {
                    if (!UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) break;
                    return "Interaction_Shape";
                }
                case "Interaction_Shape": {
                    if (!UMLPackage.eINSTANCE.getGate().isSuperTypeOf(domainElement.eClass())) break;
                    return "Gate_Shape";
                }
                case "Interaction_SubfragmentCompartment": {
                    if (UMLPackage.eINSTANCE.getLifeline().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isLifeline_FullShape(containerView, (Lifeline)domainElement)) {
                        return "Lifeline_FullShape";
                    }
                    if (!UMLPackage.eINSTANCE.getLifeline().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isLifeline_CompactShape(containerView, (Lifeline)domainElement)) break;
                    return "Lifeline_CompactShape";
                }
                case "Lifeline_FullSubfragmentCompartment": {
                    if (UMLPackage.eINSTANCE.getStateInvariant().isSuperTypeOf(domainElement.eClass())) {
                        return "StateInvariant_FullShape";
                    }
                    if (UMLPackage.eINSTANCE.getOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                        return "OccurrenceSpecification_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getMessageOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                        return "MessageOccurrenceSpecification_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getDestructionOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                        return "DestructionOccurrenceSpecification_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "DurationConstraint_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getDurationObservation().isSuperTypeOf(domainElement.eClass())) {
                        return "DurationObservation_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "TimeConstraint_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) {
                        return "TimeObservation_Shape";
                    }
                    if (!UMLPackage.eINSTANCE.getGeneralOrdering().isSuperTypeOf(domainElement.eClass())) break;
                    return "GeneralOrdering_Shape";
                }
                case "Lifeline_CompactSubfragmentCompartment": {
                    if (UMLPackage.eINSTANCE.getStateInvariant().isSuperTypeOf(domainElement.eClass())) {
                        return "StateInvariant_CompactShape";
                    }
                    if (UMLPackage.eINSTANCE.getOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                        return "OccurrenceSpecification_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getMessageOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                        return "MessageOccurrenceSpecification_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getDestructionOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                        return "DestructionOccurrenceSpecification_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "DurationConstraint_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getDurationObservation().isSuperTypeOf(domainElement.eClass())) {
                        return "DurationObservation_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "TimeConstraint_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) {
                        return "TimeObservation_Shape";
                    }
                    if (!UMLPackage.eINSTANCE.getGeneralOrdering().isSuperTypeOf(domainElement.eClass())) break;
                    return "GeneralOrdering_Shape";
                }
            }
        }
        return "";
    }

    public static boolean canCreateNode(View containerView, String nodeVisualID) {
        block154: {
            String containerVisualID;
            String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
            if (!"PapyrusUMLTimingDiagram".equals(containerModelID)) {
                return false;
            }
            if ("PapyrusUMLTimingDiagram".equals(containerModelID)) {
                containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
            } else if (containerView instanceof Diagram) {
                containerVisualID = "Package_TimingDiagram";
            } else {
                return false;
            }
            if (containerVisualID == null) break block154;
            switch (containerVisualID) {
                case "Package_TimingDiagram": {
                    if (!"Interaction_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interaction_Shape": {
                    if ("Interaction_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Interaction_SubfragmentCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Interaction_TimeRulerCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Gate_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Lifeline_FullShape": {
                    if ("Lifeline_FullNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Lifeline_FullStateDefinitionCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Lifeline_FullSubfragmentCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Lifeline_FullTimeRulerCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Lifeline_CompactShape": {
                    if ("Lifeline_CompactNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Lifeline_CompactSubfragmentCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Lifeline_CompactTimeRulerCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "StateInvariant_FullShape": {
                    if (!"StateInvariant_FullStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "StateInvariant_CompactShape": {
                    if ("StateInvariant_CompactNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"StateInvariant_CompactStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "OccurrenceSpecification_Shape": {
                    if ("OccurrenceSpecification_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"OccurrenceSpecification_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "MessageOccurrenceSpecification_Shape": {
                    if ("MessageOccurrenceSpecification_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"MessageOccurrenceSpecification_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Node_StateDefinitionShape": {
                    if (!"Node_StateDefinitionNameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "TimeConstraint_Shape": {
                    if ("TimeConstraint_BodyLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"TimeConstraint_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "TimeObservation_Shape": {
                    if ("TimeObservation_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"TimeObservation_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "DurationConstraint_Shape": {
                    if (!"DurationConstraint_BodyLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "DurationObservation_Shape": {
                    if (!"DurationObservation_NameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "GeneralOrdering_Shape": {
                    if (!"GeneralOrdering_NameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Node_FreeTimeRulerShape": {
                    if (!"Node_FreeTimeRulerCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Node_LinearTimeRulerShape": {
                    if (!"Node_LinearTimeRulerCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Node_TickShape": {
                    if (!"Node_TickNameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "DestructionOccurrenceSpecification_Shape": {
                    if ("DestructionOccurrenceSpecification_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"DestructionOccurrenceSpecification_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Gate_Shape": {
                    if (!"Gate_NameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interaction_SubfragmentCompartment": {
                    if ("Lifeline_FullShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Lifeline_CompactShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Lifeline_FullStateDefinitionCompartment": {
                    if (!"Node_StateDefinitionShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Lifeline_FullSubfragmentCompartment": {
                    if ("StateInvariant_FullShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("OccurrenceSpecification_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("MessageOccurrenceSpecification_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DestructionOccurrenceSpecification_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DurationConstraint_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DurationObservation_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Node_StateInvariantTransitionShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("TimeConstraint_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("TimeObservation_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"GeneralOrdering_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Lifeline_CompactSubfragmentCompartment": {
                    if ("StateInvariant_CompactShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("OccurrenceSpecification_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("MessageOccurrenceSpecification_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DestructionOccurrenceSpecification_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DurationConstraint_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DurationObservation_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("TimeConstraint_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("TimeObservation_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"GeneralOrdering_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interaction_TimeRulerCompartment": {
                    if ("Node_FreeTimeRulerShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Node_LinearTimeRulerShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Lifeline_FullTimeRulerCompartment": {
                    if (!"Node_FreeTimeRulerShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Lifeline_CompactTimeRulerCompartment": {
                    if (!"Node_FreeTimeRulerShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Node_FreeTimeRulerCompartment": {
                    if (!"Node_TickShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Node_LinearTimeRulerCompartment": {
                    if (!"Node_TickShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_SynchEdge": {
                    if ("Message_SynchNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_SynchStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_AsynchEdge": {
                    if ("Message_AsynchNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_AsynchStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_ReplyEdge": {
                    if ("Message_ReplyNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_ReplyStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_CreateEdge": {
                    if ("Message_CreateNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_CreateStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_DeleteEdge": {
                    if ("Message_DeleteNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_DeleteStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_LostEdge": {
                    if ("Message_LostNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_LostStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_FoundEdge": {
                    if ("Message_FoundNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_FoundStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return "";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_SynchEdge((Message)domainElement)) {
            return "Message_SynchEdge";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_AsynchEdge((Message)domainElement)) {
            return "Message_AsynchEdge";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_ReplyEdge((Message)domainElement)) {
            return "Message_ReplyEdge";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_CreateEdge((Message)domainElement)) {
            return "Message_CreateEdge";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_DeleteEdge((Message)domainElement)) {
            return "Message_DeleteEdge";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_LostEdge((Message)domainElement)) {
            return "Message_LostEdge";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_FoundEdge((Message)domainElement)) {
            return "Message_FoundEdge";
        }
        return "";
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isLifeline_FullShape(View containerView, Lifeline domainElement) {
        return LifelineUtils.getLifelineType(domainElement) == LifelineUtils.LifelineType.full;
    }

    private static boolean isLifeline_CompactShape(View containerView, Lifeline domainElement) {
        return LifelineUtils.getLifelineType(domainElement) == LifelineUtils.LifelineType.compact;
    }

    private static boolean isMessage_SynchEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(0, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_AsynchEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(1, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_ReplyEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(2, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_CreateEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(3, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_DeleteEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(4, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_LostEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(5, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_FoundEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(6, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, String candidate) {
        if (candidate == null) {
            return false;
        }
        String basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return candidate.equals(basic);
    }

    public static boolean isCompartmentVisualID(String visualID) {
        block23: {
            if (visualID == null) break block23;
            switch (visualID) {
                case "Lifeline_FullTimeRulerCompartment": 
                case "Lifeline_FullSubfragmentCompartment": 
                case "Lifeline_FullStateDefinitionCompartment": 
                case "Interaction_SubfragmentCompartment": 
                case "Lifeline_CompactTimeRulerCompartment": 
                case "Node_LinearTimeRulerCompartment": 
                case "Interaction_TimeRulerCompartment": 
                case "Lifeline_CompactSubfragmentCompartment": 
                case "Node_FreeTimeRulerCompartment": {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(String visualID) {
        block42: {
            if (visualID == null) break block42;
            switch (visualID) {
                case "Package_TimingDiagram": {
                    return false;
                }
                case "Gate_Shape": 
                case "Node_LinearTimeRulerShape": 
                case "StateInvariant_FullShape": 
                case "Lifeline_Shape": 
                case "DestructionOccurrenceSpecification_Shape": 
                case "Node_StateInvariantTransitionShape": 
                case "MessageOccurrenceSpecification_Shape": 
                case "GeneralOrdering_Shape": 
                case "OccurrenceSpecification_Shape": 
                case "StateInvariant_CompactShape": 
                case "Node_TickShape": 
                case "TimeObservation_Shape": 
                case "Node_FreeTimeRulerShape": 
                case "DurationConstraint_Shape": 
                case "Node_StateDefinitionShape": 
                case "DurationObservation_Shape": 
                case "TimeConstraint_Shape": {
                    return true;
                }
            }
        }
        return false;
    }
}

