/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.iotml.hardware.actuator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MovementKind implements Enumerator
{
    LINEAR(0, "Linear", "Linear"),
    ROTATIONAL(1, "Rotational", "Rotational");

    public static final int LINEAR_VALUE = 0;
    public static final int ROTATIONAL_VALUE = 1;
    private static final MovementKind[] VALUES_ARRAY;
    public static final List<MovementKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MovementKind[]{LINEAR, ROTATIONAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MovementKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MovementKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MovementKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MovementKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MovementKind get(int value) {
        switch (value) {
            case 0: {
                return LINEAR;
            }
            case 1: {
                return ROTATIONAL;
            }
        }
        return null;
    }

    private MovementKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

