/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.views;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.common.ui.CommonPluginImages;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.BrowserNode;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.MetamodelContainerNode;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.MetamodelNode;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.WorskpaceMetamodelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceModelNode
extends MetamodelContainerNode {
    final URI uri;
    final MetamodelNode contentNode;

    ResourceModelNode(URI resourceURI, IMetamodelDesc descriptor, BrowserNode parent) {
        super(1, ResourceModelNode.getLabel(resourceURI), ResourceModelNode.image(), parent);
        this.uri = resourceURI;
        this.contentNode = new MetamodelNode(descriptor, this, true){

            public boolean mayContain(EModelElement element) {
                return ResourceModelNode.this.uri.equals((Object)EcoreUtil.getURI((EObject)element).trimFragment()) && ResourceModelNode.this.descriptor().getLoadStatus().isOK();
            }

            public BrowserNode resolveModelElement(EModelElement element) {
                EObject collocatedElement;
                String uriFragment = EcoreUtil.getURI((EObject)element).fragment();
                EObject rootPackage = ResourceModelNode.this.contentNode.getEObject();
                if (rootPackage != null && ResourceModelNode.this.descriptor().getLoadStatus().isOK() && rootPackage.eResource() != null && uriFragment != null && (collocatedElement = rootPackage.eResource().getEObject(uriFragment)) != null) {
                    return 1.findNodeForInstance(ResourceModelNode.this.contentNode, collocatedElement);
                }
                return null;
            }

            public EPackage getSearchScopePackage() {
                if (ResourceModelNode.this.descriptor().isLoaded()) {
                    return ResourceModelNode.this.contentNode.getPackage();
                }
                EPackage result = null;
                try {
                    result = WorskpaceMetamodelProvider.loadResourceMetamodel((String)ResourceModelNode.this.uri.toString());
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
                return result;
            }
        };
    }

    static Image image() {
        return CommonPluginImages.getInstance().getImage("metamodelfile");
    }

    IMetamodelDesc descriptor() {
        return this.contentNode.descriptor;
    }

    @Override
    public boolean hasChildren(boolean includeInheritedFeatures) {
        return !this.descriptor().isLoaded() || super.hasChildren(includeInheritedFeatures);
    }

    @Override
    public List<BrowserNode> getChildren(boolean includeInheritedFeatures) {
        return Collections.singletonList(this.contentNode);
    }

    private static String getLabel(URI resourceUri) {
        if (!resourceUri.isPlatformResource()) {
            return resourceUri.toString();
        }
        Path path = new Path(resourceUri.path());
        IPath wsPath = path.removeFirstSegments(1);
        return wsPath.toString();
    }
}

