/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.ui.services.elementselection.testproviders;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.AbstractElementSelectionProvider;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.AbstractMatchingObject;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionProvider;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IMatchingObject;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IMatchingObjectsOperation;
import org.eclipse.gmf.tests.runtime.common.ui.services.dialogs.TestElementSelectionProviderContext;
import org.eclipse.gmf.tests.runtime.common.ui.services.elementselection.testproviders.TestMatchingObject;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractTestElementSelectionProvider
extends AbstractElementSelectionProvider {
    private List matchingObjects = new ArrayList();

    public AbstractTestElementSelectionProvider() {
        this.initializeMatchingObjects();
    }

    private void initializeMatchingObjects() {
        String[] names = new String[]{"One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine"};
        String component = this.getTestElementComponent();
        Image image = this.getTestElementImage();
        int i = 0;
        while (i < names.length) {
            TestMatchingObject testMatchingObject = new TestMatchingObject(names[i], component, String.valueOf(names[i]) + TestMatchingObject.DASHES + component, image, (IElementSelectionProvider)this);
            this.matchingObjects.add(testMatchingObject);
            ++i;
        }
    }

    protected abstract String getTestElementComponent();

    protected abstract Image getTestElementImage();

    public void run(IProgressMonitor monitor) {
        String filter = this.validatePattern(this.getElementSelectionInput().getInput());
        Pattern pattern = Pattern.compile(filter);
        for (AbstractMatchingObject element : this.matchingObjects) {
            Matcher matcher = pattern.matcher(element.getName().toLowerCase());
            if (matcher.matches() && this.getElementSelectionInput().getFilter().select((Object)element)) {
                this.fireMatchingObjectEvent((IMatchingObject)element);
            }
            if (monitor.isCanceled()) break;
        }
        this.fireEndOfMatchesEvent();
    }

    public boolean provides(IOperation operation) {
        assert (operation instanceof IMatchingObjectsOperation);
        IAdaptable context = ((IMatchingObjectsOperation)operation).getElementSelectionInput().getContext();
        return context instanceof TestElementSelectionProviderContext;
    }

    public Object resolve(IMatchingObject object) {
        return object.getDisplayName();
    }

    private String validatePattern(String string) {
        if (string.equals("")) {
            return string;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char c = Character.toLowerCase(string.charAt(i));
            if (c == '?') {
                result.append('.');
            } else if (c == '*') {
                result.append(".*");
            } else if (c == '?') {
                result.append("\\.");
            } else {
                result.append(c);
            }
            ++i;
        }
        result.append(".*");
        return result.toString();
    }
}

