/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.properties.descriptors;

import java.util.StringTokenizer;
import org.eclipse.gmf.runtime.common.ui.dialogs.GradientSelectionDialog;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.GradientStyle;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GradientCellEditor
extends DialogCellEditor {
    private Composite composite;
    private Label gradientLabel;

    public GradientCellEditor(Composite parent) {
        this(parent, 0);
    }

    public GradientCellEditor(Composite parent, int style) {
        super(parent, style);
        this.doSetValue(null);
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        GradientSelectionDialog dialog;
        int result;
        String value = (String)this.getValue();
        RGB color1 = null;
        RGB color2 = null;
        int gradientStyle = -1;
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, ",{}");
            try {
                GradientStyle gradientStyleObj;
                st.nextToken().trim();
                int red = Integer.parseInt(st.nextToken().trim());
                int green = Integer.parseInt(st.nextToken().trim());
                int blue = Integer.parseInt(st.nextToken().trim());
                if (red > -1 && green > -1 && blue > -1) {
                    color1 = new RGB(red, green, blue);
                }
                st.nextToken().trim();
                red = Integer.parseInt(st.nextToken().trim());
                green = Integer.parseInt(st.nextToken().trim());
                blue = Integer.parseInt(st.nextToken().trim());
                if (red > -1 && green > -1 && blue > -1) {
                    color2 = new RGB(red, green, blue);
                }
                if ((gradientStyleObj = GradientStyle.get((String)value.substring(value.lastIndexOf(44) + 1).trim())) != null) {
                    gradientStyle = gradientStyleObj.getValue();
                }
            }
            finally {
                if (color1 == null || color2 == null || gradientStyle == -1) {
                    value = null;
                }
            }
        }
        if (value == null) {
            GradientData def = GradientData.getDefaultGradientData();
            color1 = FigureUtilities.integerToRGB((Integer)def.getGradientColor1());
            color2 = FigureUtilities.integerToRGB((Integer)def.getGradientColor2());
            gradientStyle = def.getGradientStyle();
        }
        if ((result = (dialog = new GradientSelectionDialog(cellEditorWindow.getShell(), 65536, color1, color2, gradientStyle, 0)).open()) == 32) {
            return new GradientData(FigureUtilities.RGBToInteger((RGB)dialog.getGradientColor1()).intValue(), FigureUtilities.RGBToInteger((RGB)dialog.getGradientColor2()).intValue(), dialog.getGradientStyle());
        }
        this.markDirty();
        this.doSetValue(null);
        this.fireApplyEditorValue();
        return null;
    }

    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        this.composite = new Composite(cell, this.getStyle());
        this.composite.setBackground(bg);
        this.composite.setLayout((Layout)new GradientCellLayout());
        this.gradientLabel = new Label(this.composite, 16384);
        this.gradientLabel.setBackground(bg);
        this.gradientLabel.setFont(cell.getFont());
        return this.composite;
    }

    protected void updateContents(Object value) {
        if (value == null) {
            this.gradientLabel.setText("");
        } else if (value instanceof String) {
            this.gradientLabel.setText((String)value);
        } else {
            GradientData gradient = (GradientData)value;
            StringBuffer sf = new StringBuffer();
            sf.append(FigureUtilities.integerToRGB((Integer)gradient.getGradientColor1()));
            sf.append(',');
            sf.append(FigureUtilities.integerToRGB((Integer)gradient.getGradientColor2()));
            sf.append(',');
            sf.append(GradientStyle.get((int)gradient.getGradientStyle()));
            this.gradientLabel.setText(sf.toString());
        }
    }

    private class GradientCellLayout
    extends Layout {
        private GradientCellLayout() {
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point labelSize = GradientCellEditor.this.gradientLabel.computeSize(-1, -1, force);
            return new Point(labelSize.x, labelSize.y);
        }

        public void layout(Composite editor, boolean force) {
            Point gradientSize = GradientCellEditor.this.gradientLabel.computeSize(-1, -1, force);
            GradientCellEditor.this.gradientLabel.setBounds(0, 0, gradientSize.x, gradientSize.y);
        }
    }
}

