/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.resources;

import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.internal.resources.FileChangeEvent;
import org.eclipse.gmf.runtime.common.ui.internal.resources.FileChangeEventType;
import org.eclipse.gmf.runtime.common.ui.internal.resources.FileObserverFilter;
import org.eclipse.gmf.runtime.common.ui.internal.resources.FileObserverFilterType;
import org.eclipse.gmf.runtime.common.ui.internal.resources.MarkerChangeEvent;
import org.eclipse.gmf.runtime.common.ui.internal.resources.MarkerChangeEventType;
import org.eclipse.gmf.runtime.common.ui.resources.IFileObserver;

public class FileObserverManager {
    private Hashtable fileObserverList = new Hashtable();

    protected void add(IFileObserver fileObserver) {
        this.trace("...FileObserverManager: addFileObserver " + fileObserver.toString() + " filter ALL");
        FileObserverFilter filter = new FileObserverFilter(FileObserverFilterType.ALL);
        this.fileObserverList.put(fileObserver, filter);
    }

    protected void add(IFileObserver fileObserver, IFile fileFilter) {
        URI uri = fileFilter.getLocationURI();
        this.trace("...FileObserverManager: addFileObserver " + fileObserver.toString() + " filter " + (uri != null ? uri.toString() : ""));
        FileObserverFilter filter = new FileObserverFilter(FileObserverFilterType.FILE, fileFilter);
        this.fileObserverList.put(fileObserver, filter);
    }

    protected void add(IFileObserver fileObserver, IContentType[] contentTypeFilter) {
        this.trace("...FileObserverManager: addFileObserver " + fileObserver.toString() + " filter " + contentTypeFilter.toString());
        FileObserverFilter filter = new FileObserverFilter(FileObserverFilterType.CONTENT_TYPE, contentTypeFilter);
        this.fileObserverList.put(fileObserver, filter);
    }

    protected void add(IFileObserver fileObserver, IFolder folderFilter) {
        this.trace("...FileObserverManager: addFileObserver " + fileObserver.toString() + " filter folder" + folderFilter.getLocationURI().toString());
        FileObserverFilter filter = new FileObserverFilter(FileObserverFilterType.FOLDER, folderFilter);
        this.fileObserverList.put(fileObserver, filter);
    }

    protected void add(IFileObserver fileObserver, String[] extensionFilter) {
        this.trace("...FileObserverManager: addFileObserver " + fileObserver.toString() + " filter " + extensionFilter[0]);
        FileObserverFilter filter = new FileObserverFilter(FileObserverFilterType.EXTENSION, extensionFilter);
        this.fileObserverList.put(fileObserver, filter);
    }

    protected void remove(IFileObserver fileObserver) {
        if (this.fileObserverList.containsKey(fileObserver)) {
            this.trace("...FileObserverManager: removeFileObserver " + fileObserver.toString());
            this.fileObserverList.remove(fileObserver);
        }
    }

    protected void notify(FileChangeEvent event) {
        Hashtable fileObserverListCopy = (Hashtable)this.fileObserverList.clone();
        for (Map.Entry entry : fileObserverListCopy.entrySet()) {
            IFileObserver fileObserver = (IFileObserver)entry.getKey();
            FileObserverFilter filter = (FileObserverFilter)entry.getValue();
            if (event.getEventType() == FileChangeEventType.MOVED) {
                if (!filter.matches((IResource)event.getOldFile())) continue;
                this.trace("...FileObserverManager: Notify " + fileObserver.toString() + " handleFileMoved");
                fileObserver.handleFileMoved(event.getOldFile(), event.getFile());
                continue;
            }
            if (event.getEventType() == FileChangeEventType.RENAMED) {
                if (!filter.matches((IResource)event.getOldFile())) continue;
                this.trace("...FileObserverManager: Notify " + fileObserver.toString() + " handleFileRenamed");
                fileObserver.handleFileRenamed(event.getOldFile(), event.getFile());
                continue;
            }
            if (event.getEventType() == FileChangeEventType.DELETED) {
                if (!filter.matches((IResource)event.getFile())) continue;
                this.trace("...FileObserverManager: Notify " + fileObserver.toString() + " handleFileDeleted");
                fileObserver.handleFileDeleted(event.getFile());
                continue;
            }
            if (event.getEventType() != FileChangeEventType.CHANGED || !filter.matches((IResource)event.getFile())) continue;
            this.trace("...FileObserverManager: Notify " + fileObserver.toString() + " handleFileChanged");
            fileObserver.handleFileChanged(event.getFile());
        }
    }

    protected void notify(MarkerChangeEvent event) {
        Hashtable fileObserverListCopy = (Hashtable)this.fileObserverList.clone();
        for (Map.Entry entry : fileObserverListCopy.entrySet()) {
            IFileObserver fileObserver = (IFileObserver)entry.getKey();
            FileObserverFilter filter = (FileObserverFilter)entry.getValue();
            if (!filter.matches(event.getMarker().getResource())) continue;
            if (event.getEventType() == MarkerChangeEventType.ADDED) {
                this.trace("...FileObserverManager: Notify " + fileObserver.toString() + " handleMarkerAdded");
                fileObserver.handleMarkerAdded(event.getMarker());
                continue;
            }
            if (event.getEventType() == MarkerChangeEventType.CHANGED) {
                this.trace("...FileObserverManager: Notify " + fileObserver.toString() + " handleMarkerChanged");
                fileObserver.handleMarkerChanged(event.getMarker());
                continue;
            }
            if (event.getEventType() != MarkerChangeEventType.REMOVED) continue;
            this.trace("...FileObserverManager: Notify " + fileObserver.toString() + " handleMarkerDeleted");
            fileObserver.handleMarkerDeleted(event.getMarker(), event.getAttributes());
        }
    }

    private void trace(String message) {
        if (Trace.shouldTrace((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.RESOURCE)) {
            Trace.trace((Plugin)CommonUIPlugin.getDefault(), (String)message);
        }
    }
}

