/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.part;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramEditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramModificationListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDiagramModificationListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDocumentProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IFileEditorInput;

public class GMFGraphDocumentProvider
extends FileDiagramDocumentProvider {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.graphdef.editor.part.GMFGraphDocumentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected void saveDocumentToFile(IDocument document, IFile file, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        Diagram diagram = (Diagram)document.getContent();
        Resource diagramResource = diagram.eResource();
        IDiagramDocument diagramDocument = (IDiagramDocument)document;
        TransactionalEditingDomain domain = diagramDocument.getEditingDomain();
        EList resources = domain.getResourceSet().getResources();
        monitor.beginTask("Saving diagram", resources.size() + 1);
        super.saveDocumentToFile(document, file, overwrite, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            Resource nextResource = (Resource)it.next();
            monitor.setTaskName("Saving " + nextResource.getURI());
            if (nextResource != diagramResource) {
                try {
                    nextResource.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    GMFGraphDiagramEditorPlugin.getInstance().logError("Unable to save resource: " + nextResource.getURI(), e);
                }
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    protected ISchedulingRule getSaveRule(Object element) {
        Diagram diagram;
        IDiagramDocument diagramDocument = this.getDiagramDocument(element);
        if (diagramDocument != null && (diagram = diagramDocument.getDiagram()) != null) {
            ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
            Iterator it = diagramDocument.getEditingDomain().getResourceSet().getResources().iterator();
            while (it.hasNext()) {
                IFile nextFile = WorkspaceSynchronizer.getFile((Resource)((Resource)it.next()));
                if (nextFile == null) continue;
                rules.add(this.computeSaveSchedulingRule((IResource)nextFile));
            }
            return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
        }
        return super.getSaveRule(element);
    }

    protected FileDocumentProvider.FileInfo createFileInfo(IDocument document, FileDocumentProvider.FileSynchronizer synchronizer, IFileEditorInput input) {
        if (!$assertionsDisabled && !(document instanceof DiagramDocument)) {
            throw new AssertionError();
        }
        CustomModificationListener diagramListener = new CustomModificationListener(this, (DiagramDocument)document, input);
        FileDiagramDocumentProvider.DiagramFileInfo info = new FileDiagramDocumentProvider.DiagramFileInfo((FileDiagramDocumentProvider)this, document, synchronizer, (DiagramModificationListener)diagramListener);
        diagramListener.startListening();
        return info;
    }

    private ISchedulingRule computeSaveSchedulingRule(IResource toCreateOrModify) {
        if (toCreateOrModify.exists() && toCreateOrModify.isSynchronized(0)) {
            return this.fResourceRuleFactory.modifyRule(toCreateOrModify);
        }
        IResource parent = toCreateOrModify;
        while ((parent = (toCreateOrModify = parent).getParent()) != null && !parent.exists() && !parent.isSynchronized(0)) {
        }
        return this.fResourceRuleFactory.createRule(toCreateOrModify);
    }

    private class CustomModificationListener
    extends FileDiagramModificationListener {
        private DemultiplexingListener myListener;

        public CustomModificationListener(GMFGraphDocumentProvider documentProviderParameter, DiagramDocument documentParameter, IFileEditorInput inputParameter) {
            super((FileDocumentProvider)documentProviderParameter, documentParameter, inputParameter);
            this.myListener = null;
            DiagramDocument document = documentParameter;
            NotificationFilter diagramResourceModifiedFilter = NotificationFilter.createEventTypeFilter((int)1);
            this.myListener = new DemultiplexingListener(this, diagramResourceModifiedFilter, document){
                final /* synthetic */ CustomModificationListener this$1;
                private final /* synthetic */ DiagramDocument val$document;
                {
                    this.this$1 = customModificationListener;
                    this.val$document = diagramDocument;
                    super($anonymous0);
                }

                protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
                    Resource modifiedResource;
                    if (notification.getNotifier() instanceof EObject && (modifiedResource = ((EObject)notification.getNotifier()).eResource()) != this.val$document.getDiagram().eResource()) {
                        this.val$document.setContent(this.val$document.getContent());
                    }
                }
            };
        }

        public void startListening() {
            super.startListening();
            this.getEditingDomain().addResourceSetListener((ResourceSetListener)this.myListener);
        }

        public void stopListening() {
            this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.myListener);
            super.stopListening();
        }
    }
}

