/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.gmf.internal.xpand.expression.TypesComparator;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolymorphicResolver {
    private static final TypesComparator typesComparator = new TypesComparator();

    public static XpandDefinition filterDefinition(final HashMap<XpandDefinition, List<EClassifier>> resolvedDefs, EClassifier targetType, List<EClassifier> paramTypes) {
        ArrayList<EClassifier> allParams = new ArrayList<EClassifier>();
        allParams.add(targetType);
        allParams.addAll(paramTypes);
        ArrayList<XpandDefinition> candidateDefinition = new ArrayList<XpandDefinition>();
        for (XpandDefinition def : resolvedDefs.keySet()) {
            List<EClassifier> featureParamTypes = resolvedDefs.get(def);
            if (featureParamTypes.size() != allParams.size() || typesComparator.compare((List<? extends EClassifier>)featureParamTypes, (List<? extends EClassifier>)allParams) < 0) continue;
            candidateDefinition.add(def);
        }
        Comparator<XpandDefinition> comparator = new Comparator<XpandDefinition>(){

            @Override
            public int compare(XpandDefinition d1, XpandDefinition d2) {
                return typesComparator.compare((List)resolvedDefs.get(d1), (List)resolvedDefs.get(d2));
            }
        };
        try {
            return PolymorphicResolver.filterWithComparator(candidateDefinition, comparator);
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException("Ambiguous definitions " + ((XpandDefinition)candidateDefinition.get(0)).toString() + " and " + ((XpandDefinition)candidateDefinition.get(1)).toString() + " for param types " + paramTypes);
        }
    }

    public static final Extension getExtension(Set<Extension> extensions, String name, List<EClassifier> paramTypes) {
        ArrayList<Extension> candidateExtensions = new ArrayList<Extension>();
        for (Extension ext : extensions) {
            List<EClassifier> featureParamTypes;
            if (!ext.getName().equals(name) || (featureParamTypes = ext.getParameterTypes()).size() != paramTypes.size() || typesComparator.compare(featureParamTypes, paramTypes) < 0) continue;
            candidateExtensions.add(ext);
        }
        Comparator<Extension> extensionComparator = new Comparator<Extension>(){

            @Override
            public int compare(Extension e1, Extension e2) {
                return typesComparator.compare(e1.getParameterTypes(), e2.getParameterTypes());
            }
        };
        try {
            return PolymorphicResolver.filterWithComparator(candidateExtensions, extensionComparator);
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException("Ambiguous extensions " + ((Extension)candidateExtensions.get(0)).toString() + " and " + ((Extension)candidateExtensions.get(1)).toString() + " for param types " + paramTypes);
        }
    }

    public static EOperation filterOperation(List<EOperation> allOperations, String name, EClassifier targetType, List<EClassifier> paramTypes) {
        final HashMap candidates = new HashMap();
        ArrayList<EClassifier> expectedParamsWithTarget = new ArrayList<EClassifier>(paramTypes.size() + 1);
        expectedParamsWithTarget.add(targetType);
        expectedParamsWithTarget.addAll(paramTypes);
        for (EOperation op : allOperations) {
            if (!op.getName().equals(name) || op.getEParameters().size() != paramTypes.size()) continue;
            ArrayList<Object> candidateOperationParams = new ArrayList<Object>(paramTypes.size() + 1);
            if (op.getEContainingClass() != null) {
                candidateOperationParams.add(op.getEContainingClass());
            }
            EList allParams = op.getEParameters();
            for (EParameter p : allParams) {
                candidateOperationParams.add(p.getEType());
            }
            if (typesComparator.compare((List<? extends EClassifier>)candidateOperationParams, (List<? extends EClassifier>)(op.getEContainingClass() != null ? expectedParamsWithTarget : paramTypes)) < 0) continue;
            candidates.put(op, candidateOperationParams);
        }
        Comparator<EOperation> comparator = new Comparator<EOperation>(){

            @Override
            public int compare(EOperation o1, EOperation o2) {
                return typesComparator.compare((List)candidates.get(o1), (List)candidates.get(o2));
            }
        };
        LinkedList candidates2 = new LinkedList();
        try {
            candidates2.addAll(candidates.keySet());
            return PolymorphicResolver.filterWithComparator(candidates2, comparator);
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException("Ambiguous definitions " + ((EOperation)candidates2.get(0)).toString() + " and " + ((EOperation)candidates2.get(1)).toString() + " for param types " + paramTypes);
        }
    }

    private static <T> T filterWithComparator(List<T> candidates, Comparator<T> comparator) throws IllegalStateException {
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        Collections.sort(candidates, comparator);
        if (comparator.compare(candidates.get(1), candidates.get(0)) > 0) {
            return candidates.get(0);
        }
        throw new IllegalStateException();
    }
}

