/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.common.utils.file;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.search.core.scope.IModelSearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreModelSearchScopeFileSystemVisitor {
    IModelSearchScope<Object, Resource> modelSearchScope;

    public EcoreModelSearchScopeFileSystemVisitor(IModelSearchScope<Object, Resource> scope) {
        this.modelSearchScope = scope;
    }

    public boolean visit(File file) {
        if (this.isParticipantCurrentSearchEngineValid(file)) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createFileURI((String)file.getAbsolutePath());
            this.initResourceSet((ResourceSet)resourceSet, fileURI);
            try {
                Resource resource = resourceSet.getResource(fileURI, true);
                if (resource instanceof Resource) {
                    this.modelSearchScope.addParticipant((Object)resource);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public IModelSearchScope<Object, Resource> getModelSearchScope() {
        return this.modelSearchScope;
    }

    protected void initResourceSet(ResourceSet resourceSet, URI fileURI) {
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    protected boolean isParticipantCurrentSearchEngineValid(File f) {
        if (f instanceof File && f.canRead() && f.exists() && !f.isHidden()) {
            return f.getName().endsWith(".ecore");
        }
        return false;
    }
}

