/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.debug.launching.ui.launchable;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.mwe.internal.ui.debug.launching.ui.launchable.XMLContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class LaunchableTester
extends PropertyTester {
    private static final String ROOT_ELEMENT_NAME = "workflow";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver == null) {
            return false;
        }
        IAdaptable adaptable = (IAdaptable)receiver;
        IFile file = (IFile)adaptable.getAdapter(IFile.class);
        if (file != null) {
            return this.checkFileCriteria(file);
        }
        return false;
    }

    private boolean checkFileCriteria(IFile file) {
        if (!file.exists()) {
            return false;
        }
        try {
            InputStream stream = file.getContents();
            XMLContentHandler contentHandler = new XMLContentHandler();
            XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            reader.setContentHandler(contentHandler);
            InputSource inputSource = new InputSource(stream);
            reader.parse(inputSource);
            String rootName = contentHandler.getRootName();
            return ROOT_ELEMENT_NAME.equals(rootName);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

