/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.tests;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.EMFOperationCommand;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.emf.workspace.tests.AbstractTest;

public class MemoryLeakTest
extends AbstractTest {
    public MemoryLeakTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(MemoryLeakTest.class, "Memory Leak (GC) Tests");
    }

    public void test_crossReferenceAdapter_undoredo_normalCommands() {
        ECrossReferenceAdapter xrefAdapter = new ECrossReferenceAdapter();
        this.domain.getResourceSet().eAdapters().add((Object)xrefAdapter);
        TransactionSniffer sniffer = new TransactionSniffer(this.domain);
        EObject level1 = this.find(this.root, "level1");
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        RemoveCommand cmd = new RemoveCommand((EditingDomain)this.domain, (EObject)this.root, (EStructuralFeature)EXTLibraryPackage.Literals.LIBRARY__BRANCHES, level1){

            public void doDispose() {
                if (this.feature instanceof EReference && ((EReference)this.feature).isContainment()) {
                    for (Object o : this.collection) {
                        EObject next = (EObject)o;
                        if (next.eContainer() == this.owner) continue;
                        next.eAdapters().clear();
                    }
                }
                super.doDispose();
            }
        };
        this.getCommandStack().execute((Command)cmd);
        ResourceUndoContext resctx = new ResourceUndoContext(this.domain, this.testResource);
        this.history.getUndoOperation((IUndoContext)resctx).removeContext((IUndoContext)resctx);
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().undo();
        this.getCommandStack().redo();
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().flush();
        MemoryLeakTest.assertFalse((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        sniffer.assertChangesDisposed();
    }

    public void test_crossReferenceAdapter_undoredo_recordingCommands() {
        ECrossReferenceAdapter xrefAdapter = new ECrossReferenceAdapter();
        this.domain.getResourceSet().eAdapters().add((Object)xrefAdapter);
        TransactionSniffer sniffer = new TransactionSniffer(this.domain);
        final EObject level1 = this.find(this.root, "level1");
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        RecordingCommand cmd = new RecordingCommand(this.domain, "Remove Branch"){

            protected void doExecute() {
                MemoryLeakTest.this.root.getBranches().remove((Object)level1);
            }
        };
        this.getCommandStack().execute((Command)cmd);
        ResourceUndoContext resctx = new ResourceUndoContext(this.domain, this.testResource);
        this.history.getUndoOperation((IUndoContext)resctx).removeContext((IUndoContext)resctx);
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().undo();
        this.getCommandStack().redo();
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().flush();
        MemoryLeakTest.assertFalse((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        sniffer.assertChangesDisposed();
    }

    public void test_crossReferenceAdapter_undoredo_normalTriggerCommands() {
        ECrossReferenceAdapter xrefAdapter = new ECrossReferenceAdapter();
        this.domain.getResourceSet().eAdapters().add((Object)xrefAdapter);
        TransactionSniffer sniffer = new TransactionSniffer(this.domain);
        EObject level1 = this.find(this.root, "level1");
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        RemoveCommand trigger = new RemoveCommand((EditingDomain)this.domain, (EObject)this.root, (EStructuralFeature)EXTLibraryPackage.Literals.LIBRARY__BRANCHES, level1){

            public void doDispose() {
                if (this.feature instanceof EReference && ((EReference)this.feature).isContainment()) {
                    for (Object o : this.collection) {
                        EObject next = (EObject)o;
                        if (next.eContainer() == this.owner) continue;
                        next.eAdapters().clear();
                    }
                }
                super.doDispose();
            }
        };
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener((Command)trigger){
            private final /* synthetic */ Command val$trigger;
            {
                this.val$trigger = command;
            }

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                if (notification.getFeature() == EXTLibraryPackage.Literals.LIBRARY__NAME) {
                    return this.val$trigger;
                }
                return null;
            }
        });
        Command cmd = this.domain.createCommand(SetCommand.class, new CommandParameter((Object)this.root, (Object)EXTLibraryPackage.Literals.LIBRARY__NAME, (Object)"newname"));
        this.getCommandStack().execute(cmd);
        ResourceUndoContext resctx = new ResourceUndoContext(this.domain, this.testResource);
        this.history.getUndoOperation((IUndoContext)resctx).removeContext((IUndoContext)resctx);
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().undo();
        this.getCommandStack().redo();
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().flush();
        MemoryLeakTest.assertFalse((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        sniffer.assertChangesDisposed();
    }

    public void test_crossReferenceAdapter_undoredo_recordingTriggerCommands() {
        ECrossReferenceAdapter xrefAdapter = new ECrossReferenceAdapter();
        this.domain.getResourceSet().eAdapters().add((Object)xrefAdapter);
        TransactionSniffer sniffer = new TransactionSniffer(this.domain);
        final EObject level1 = this.find(this.root, "level1");
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        RecordingCommand trigger = new RecordingCommand(this.domain, "Remove Branch"){

            protected void doExecute() {
                MemoryLeakTest.this.root.getBranches().remove((Object)level1);
            }
        };
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener((Command)trigger){
            private final /* synthetic */ Command val$trigger;
            {
                this.val$trigger = command;
            }

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                if (notification.getFeature() == EXTLibraryPackage.Literals.LIBRARY__NAME) {
                    return this.val$trigger;
                }
                return null;
            }
        });
        Command cmd = this.domain.createCommand(SetCommand.class, new CommandParameter((Object)this.root, (Object)EXTLibraryPackage.Literals.LIBRARY__NAME, (Object)"newname"));
        this.getCommandStack().execute(cmd);
        ResourceUndoContext resctx = new ResourceUndoContext(this.domain, this.testResource);
        this.history.getUndoOperation((IUndoContext)resctx).removeContext((IUndoContext)resctx);
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().undo();
        this.getCommandStack().redo();
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().flush();
        MemoryLeakTest.assertFalse((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        sniffer.assertChangesDisposed();
    }

    public void test_crossReferenceAdapter_undoredo_operations() {
        ECrossReferenceAdapter xrefAdapter = new ECrossReferenceAdapter();
        this.domain.getResourceSet().eAdapters().add((Object)xrefAdapter);
        TransactionSniffer sniffer = new TransactionSniffer(this.domain);
        final EObject level1 = this.find(this.root, "level1");
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        AbstractEMFOperation oper = new AbstractEMFOperation(this.domain, "Remove Branch"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                MemoryLeakTest.this.root.getBranches().remove((Object)level1);
                return Status.OK_STATUS;
            }
        };
        UndoContext ctx = new UndoContext();
        oper.addContext((IUndoContext)ctx);
        try {
            this.history.execute((IUndoableOperation)oper, null, null);
        }
        catch (ExecutionException e) {
            MemoryLeakTest.fail((String)("Failed to execute operation: " + e.getLocalizedMessage()));
        }
        ResourceUndoContext resctx = new ResourceUndoContext(this.domain, this.testResource);
        this.history.getUndoOperation((IUndoContext)resctx).removeContext((IUndoContext)resctx);
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        try {
            this.history.undo((IUndoContext)ctx, null, null);
        }
        catch (ExecutionException e) {
            MemoryLeakTest.fail((String)("Failed to undo operation: " + e.getLocalizedMessage()));
        }
        try {
            this.history.redo((IUndoContext)ctx, null, null);
        }
        catch (ExecutionException e) {
            MemoryLeakTest.fail((String)("Failed to redo operation: " + e.getLocalizedMessage()));
        }
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.history.dispose((IUndoContext)ctx, true, true, true);
        MemoryLeakTest.assertFalse((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        sniffer.assertChangesDisposed();
    }

    public void test_crossReferenceAdapter_undoredo_operationTriggerCommands() {
        ECrossReferenceAdapter xrefAdapter = new ECrossReferenceAdapter();
        this.domain.getResourceSet().eAdapters().add((Object)xrefAdapter);
        TransactionSniffer sniffer = new TransactionSniffer(this.domain);
        final EObject level1 = this.find(this.root, "level1");
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        RecordingCommand trigger = new RecordingCommand(this.domain, "Remove Branch"){

            protected void doExecute() {
                MemoryLeakTest.this.root.getBranches().remove((Object)level1);
            }
        };
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener((Command)trigger){
            private final /* synthetic */ Command val$trigger;
            {
                this.val$trigger = command;
            }

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                if (notification.getFeature() == EXTLibraryPackage.Literals.LIBRARY__NAME) {
                    return this.val$trigger;
                }
                return null;
            }
        });
        AbstractEMFOperation oper = new AbstractEMFOperation(this.domain, "Rename Library"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                MemoryLeakTest.this.root.setName("newname");
                return Status.OK_STATUS;
            }
        };
        UndoContext ctx = new UndoContext();
        oper.addContext((IUndoContext)ctx);
        try {
            this.history.execute((IUndoableOperation)oper, null, null);
        }
        catch (ExecutionException e) {
            MemoryLeakTest.fail((String)("Failed to execute operation: " + e.getLocalizedMessage()));
        }
        ResourceUndoContext resctx = new ResourceUndoContext(this.domain, this.testResource);
        this.history.getUndoOperation((IUndoContext)resctx).removeContext((IUndoContext)resctx);
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        try {
            this.history.undo((IUndoContext)ctx, null, null);
        }
        catch (ExecutionException e) {
            MemoryLeakTest.fail((String)("Failed to undo operation: " + e.getLocalizedMessage()));
        }
        try {
            this.history.redo((IUndoContext)ctx, null, null);
        }
        catch (ExecutionException e) {
            MemoryLeakTest.fail((String)("Failed to redo operation: " + e.getLocalizedMessage()));
        }
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.history.dispose((IUndoContext)ctx, true, true, true);
        MemoryLeakTest.assertFalse((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        sniffer.assertChangesDisposed();
    }

    public void test_crossReferenceAdapter_undoredo_operationTriggerOperations() {
        ECrossReferenceAdapter xrefAdapter = new ECrossReferenceAdapter();
        this.domain.getResourceSet().eAdapters().add((Object)xrefAdapter);
        TransactionSniffer sniffer = new TransactionSniffer(this.domain);
        final EObject level1 = this.find(this.root, "level1");
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        AbstractEMFOperation triggerOper = new AbstractEMFOperation(this.domain, "Remove Branch"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                MemoryLeakTest.this.root.getBranches().remove((Object)level1);
                return Status.OK_STATUS;
            }
        };
        EMFOperationCommand trigger = new EMFOperationCommand(this.domain, (IUndoableOperation)triggerOper);
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener((Command)trigger){
            private final /* synthetic */ Command val$trigger;
            {
                this.val$trigger = command;
            }

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                if (notification.getFeature() == EXTLibraryPackage.Literals.LIBRARY__NAME) {
                    return this.val$trigger;
                }
                return null;
            }
        });
        AbstractEMFOperation oper = new AbstractEMFOperation(this.domain, "Rename Library"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                MemoryLeakTest.this.root.setName("newname");
                return Status.OK_STATUS;
            }
        };
        UndoContext ctx = new UndoContext();
        oper.addContext((IUndoContext)ctx);
        try {
            this.history.execute((IUndoableOperation)oper, null, null);
        }
        catch (ExecutionException e) {
            MemoryLeakTest.fail((String)("Failed to execute operation: " + e.getLocalizedMessage()));
        }
        ResourceUndoContext resctx = new ResourceUndoContext(this.domain, this.testResource);
        this.history.getUndoOperation((IUndoContext)resctx).removeContext((IUndoContext)resctx);
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        try {
            this.history.undo((IUndoContext)ctx, null, null);
        }
        catch (ExecutionException e) {
            MemoryLeakTest.fail((String)("Failed to undo operation: " + e.getLocalizedMessage()));
        }
        try {
            this.history.redo((IUndoContext)ctx, null, null);
        }
        catch (ExecutionException e) {
            MemoryLeakTest.fail((String)("Failed to redo operation: " + e.getLocalizedMessage()));
        }
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.history.dispose((IUndoContext)ctx, true, true, true);
        MemoryLeakTest.assertFalse((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        sniffer.assertChangesDisposed();
    }

    private static class TransactionSniffer
    extends ResourceSetListenerImpl {
        private final TransactionalEditingDomain domain;
        private final List<ChangeDescription> changes = new ArrayList<ChangeDescription>();

        TransactionSniffer(TransactionalEditingDomain domain) {
            this.domain = domain;
            domain.addResourceSetListener((ResourceSetListener)this);
        }

        public boolean isPostcommitOnly() {
            return true;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            Transaction tx = event.getTransaction();
            if (tx != null && tx.getChangeDescription() != null) {
                this.changes.add((ChangeDescription)tx.getChangeDescription());
            }
        }

        void assertChangesDisposed() {
            this.domain.removeResourceSetListener((ResourceSetListener)this);
            TreeIterator iter = EcoreUtil.getAllContents(this.changes);
            while (iter.hasNext()) {
                EObject next = (EObject)iter.next();
                MemoryLeakTest.assertEquals((String)"Adapters not cleared.", (int)0, (int)next.eAdapters().size());
            }
        }
    }
}

