/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectOutput;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.types.CharStreamHeaderGenerator;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.shared.common.error.StandardException;

public final class ClobStreamHeaderGenerator
implements StreamHeaderGenerator {
    private static final byte MAGIC_BYTE = -16;
    private static final byte[] UNKNOWN_LENGTH = new byte[]{0, 0, -16, 0, 0};
    private static final CharStreamHeaderGenerator CHARHDRGEN = new CharStreamHeaderGenerator();
    private final StringDataValue callbackDVD;
    private Boolean isPreDerbyTenFive;

    public ClobStreamHeaderGenerator(StringDataValue dvd) {
        if (dvd == null) {
            throw new IllegalStateException("dvd cannot be null");
        }
        this.callbackDVD = dvd;
    }

    public ClobStreamHeaderGenerator(boolean isPreDerbyTenFive) {
        this.callbackDVD = null;
        this.isPreDerbyTenFive = isPreDerbyTenFive;
    }

    @Override
    public boolean expectsCharCount() {
        if (this.callbackDVD != null && this.isPreDerbyTenFive == null) {
            this.determineHeaderFormat();
        }
        return this.isPreDerbyTenFive == false;
    }

    @Override
    public int generateInto(byte[] buf, int offset, long valueLength) {
        if (this.callbackDVD != null && this.isPreDerbyTenFive == null) {
            this.determineHeaderFormat();
        }
        int headerLength = 0;
        if (this.isPreDerbyTenFive == Boolean.FALSE) {
            if (valueLength >= 0L) {
                buf[offset + headerLength++] = (byte)(valueLength >>> 24);
                buf[offset + headerLength++] = (byte)(valueLength >>> 16);
                buf[offset + headerLength++] = -16;
                buf[offset + headerLength++] = (byte)(valueLength >>> 8);
                buf[offset + headerLength++] = (byte)(valueLength >>> 0);
            } else {
                headerLength = UNKNOWN_LENGTH.length;
                System.arraycopy(UNKNOWN_LENGTH, 0, buf, offset, headerLength);
            }
        } else {
            headerLength = CHARHDRGEN.generateInto(buf, offset, valueLength);
        }
        return headerLength;
    }

    @Override
    public int generateInto(ObjectOutput out, long valueLength) throws IOException {
        if (this.callbackDVD != null && this.isPreDerbyTenFive == null) {
            this.determineHeaderFormat();
        }
        int headerLength = 0;
        if (this.isPreDerbyTenFive == Boolean.FALSE) {
            headerLength = 5;
            if (valueLength > 0L) {
                out.writeByte((byte)(valueLength >>> 24));
                out.writeByte((byte)(valueLength >>> 16));
                out.writeByte(-16);
                out.writeByte((byte)(valueLength >>> 8));
                out.writeByte((byte)(valueLength >>> 0));
            } else {
                out.write(UNKNOWN_LENGTH);
            }
        } else {
            headerLength = CHARHDRGEN.generateInto(out, valueLength);
        }
        return headerLength;
    }

    @Override
    public int writeEOF(byte[] buffer, int offset, long valueLength) {
        if (this.callbackDVD != null && this.isPreDerbyTenFive == null) {
            this.determineHeaderFormat();
        }
        if (!this.isPreDerbyTenFive.booleanValue()) {
            if (valueLength < 0L) {
                return CharStreamHeaderGenerator.writeEOFMarker(buffer, offset);
            }
            return 0;
        }
        return CHARHDRGEN.writeEOF(buffer, offset, valueLength);
    }

    @Override
    public int writeEOF(ObjectOutput out, long valueLength) throws IOException {
        if (this.callbackDVD != null && this.isPreDerbyTenFive == null) {
            this.determineHeaderFormat();
        }
        if (!this.isPreDerbyTenFive.booleanValue()) {
            if (valueLength < 0L) {
                return CharStreamHeaderGenerator.writeEOFMarker(out);
            }
            return 0;
        }
        return CHARHDRGEN.writeEOF(out, valueLength);
    }

    @Override
    public int getMaxHeaderLength() {
        return 5;
    }

    private void determineHeaderFormat() {
        DatabaseContext dbCtx = (DatabaseContext)ClobStreamHeaderGenerator.getContext("Database");
        if (dbCtx == null) {
            throw new IllegalStateException("No context, unable to determine which stream header format to generate");
        }
        DataDictionary dd = dbCtx.getDatabase().getDataDictionary();
        try {
            this.isPreDerbyTenFive = !dd.checkVersion(170, null);
        }
        catch (StandardException se) {
            IllegalStateException ise = new IllegalStateException(se.getMessage());
            ise.initCause(se);
            throw ise;
        }
        this.callbackDVD.setStreamHeaderFormat(this.isPreDerbyTenFive);
    }

    private static Context getContext(String contextID) {
        return ContextService.getContext(contextID);
    }
}

