/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j.bundle;

import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;

public class Net4jCommandProvider
implements CommandProvider {
    private static final String NEW_LINE = "\r\n";
    private static final String INDENT = "   ";

    public Net4jCommandProvider(BundleContext bundleContext) {
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public String getHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("---Net4j commands---\r\n");
        buffer.append("   elements - list all managed elements\r\n");
        buffer.append("   acceptors - list all active acceptors, their connectors and channels\r\n");
        buffer.append("   connectors - list all active connectors and their channels\r\n");
        return buffer.toString();
    }

    public Object _elements(CommandInterpreter interpreter) {
        try {
            for (String productGroup : this.getContainer().getProductGroups()) {
                interpreter.println((Object)productGroup);
                this.printFactoryTypes(interpreter, productGroup, INDENT);
            }
        }
        catch (Exception ex) {
            interpreter.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public Object _acceptors(CommandInterpreter interpreter) {
        try {
            this.printFactoryTypes(interpreter, "org.eclipse.net4j.acceptors", "");
        }
        catch (Exception ex) {
            interpreter.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public Object _connectors(CommandInterpreter interpreter) {
        try {
            this.printFactoryTypes(interpreter, "org.eclipse.net4j.connectors", "");
        }
        catch (Exception ex) {
            interpreter.printStackTrace((Throwable)ex);
        }
        return null;
    }

    protected IPluginContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    private void printFactoryTypes(CommandInterpreter interpreter, String productGroup, String prefix) {
        IPluginContainer container = this.getContainer();
        for (String factoryType : container.getFactoryTypes(productGroup)) {
            Object[] elements = container.getElements(productGroup, factoryType);
            interpreter.println((Object)(String.valueOf(prefix) + factoryType + " (" + elements.length + ")"));
            this.printElements(interpreter, elements, String.valueOf(prefix) + INDENT);
        }
    }

    private void printElements(CommandInterpreter interpreter, Object[] elements, String prefix) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            interpreter.println((Object)(String.valueOf(prefix) + element));
            if (element instanceof IContainer) {
                IContainer container = (IContainer)element;
                this.printElements(interpreter, container.getElements(), String.valueOf(prefix) + INDENT);
            }
            ++n2;
        }
    }
}

