/*
 * Copyright (c) 2007, 2008, 2011, 2012, 2015, 2016 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.net4j.internal.jms.protocol;

import org.eclipse.net4j.internal.jms.DestinationImpl;
import org.eclipse.net4j.internal.jms.util.DestinationUtil;
import org.eclipse.net4j.jms.JMSProtocolConstants;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

/**
 * @author Eike Stepper
 */
public class JMSRegisterConsumerRequest extends RequestWithConfirmation<Long>
{
  private int sessionID;

  private DestinationImpl destination;

  private String messageSelector;

  private boolean noLocal;

  private boolean durable;

  /**
   * @since 2.0
   */
  public JMSRegisterConsumerRequest(JMSClientProtocol protocol, int sessionID, DestinationImpl destination, String messageSelector, boolean noLocal,
      boolean durable)
  {
    super(protocol, JMSProtocolConstants.SIGNAL_REGISTER_CONSUMER);
    this.sessionID = sessionID;
    this.destination = destination;
    this.messageSelector = messageSelector;
    this.noLocal = noLocal;
    this.durable = durable;
  }

  @Override
  protected void requesting(ExtendedDataOutputStream out) throws Exception
  {
    out.writeInt(sessionID);
    DestinationUtil.write(out, destination);
    out.writeString(messageSelector);
    out.writeBoolean(noLocal);
    out.writeBoolean(durable);
  }

  @Override
  protected Long confirming(ExtendedDataInputStream in) throws Exception
  {
    return in.readLong();
  }
}
