/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.derby.impl.store.raw.data.ByteHolder;
import org.apache.derby.shared.common.sanity.SanityManager;

public class MemByteHolder
implements ByteHolder {
    int bufSize;
    boolean writing = true;
    Vector<byte[]> bufV;
    int curBufVEleAt;
    byte[] curBuf;
    int curBufPos;
    int curBufDataBytes;
    int lastBufVEleAt = 0;
    int lastBufDataBytes = 0;

    public MemByteHolder(int bufSize) {
        this.bufSize = bufSize;
        this.curBuf = new byte[bufSize];
        this.curBufPos = 0;
        this.bufV = new Vector(128);
        this.bufV.addElement(this.curBuf);
        this.curBufVEleAt = 0;
    }

    @Override
    public void write(int b) throws IOException {
        SanityManager.ASSERT(this.writing, "Writing should be true 1");
        if (this.curBufPos >= this.curBuf.length) {
            this.getNextBuffer_w();
        }
        this.curBuf[this.curBufPos++] = (byte)b;
    }

    @Override
    public void write(byte[] data, int offset, int len) throws IOException {
        SanityManager.ASSERT(this.writing, "Writing should be true 2");
        while (len > 0) {
            int bytesInCurBuf;
            int bytesToCopyThisTime;
            if (this.curBufPos >= this.curBuf.length) {
                this.getNextBuffer_w();
            }
            if ((bytesToCopyThisTime = len) > (bytesInCurBuf = this.curBuf.length - this.curBufPos)) {
                bytesToCopyThisTime = bytesInCurBuf;
            }
            System.arraycopy(data, offset, this.curBuf, this.curBufPos, bytesToCopyThisTime);
            offset += bytesToCopyThisTime;
            this.curBufPos += bytesToCopyThisTime;
            len -= bytesToCopyThisTime;
        }
    }

    @Override
    public long write(InputStream is, long count) throws IOException {
        long bytesToTransfer = count;
        int bytesTransferredThisTime = 0;
        do {
            int bytesInCurBuf;
            int bytesToTransferThisTime;
            if (this.curBufPos >= this.curBuf.length) {
                this.getNextBuffer_w();
            }
            if ((bytesTransferredThisTime = is.read(this.curBuf, this.curBufPos, bytesToTransferThisTime = bytesToTransfer >= (long)(bytesInCurBuf = this.curBuf.length - this.curBufPos) ? bytesInCurBuf : (int)bytesToTransfer)) <= 0) continue;
            SanityManager.ASSERT(this.writing, "Writing should be true 3");
            bytesToTransfer -= (long)bytesTransferredThisTime;
            this.curBufPos += bytesTransferredThisTime;
        } while (bytesToTransfer > 0L && bytesTransferredThisTime > 0);
        return count - bytesToTransfer;
    }

    @Override
    public void clear() throws IOException {
        this.writing = true;
        this.curBuf = this.bufV.elementAt(0);
        this.curBufVEleAt = 0;
        this.curBufPos = 0;
        this.lastBufVEleAt = 0;
        this.lastBufDataBytes = 0;
    }

    @Override
    public void startReading() throws IOException {
        if (this.writing) {
            this.writing = false;
            this.lastBufDataBytes = this.curBufPos;
            this.lastBufVEleAt = this.curBufVEleAt;
        }
        this.curBuf = this.bufV.elementAt(0);
        this.curBufVEleAt = 0;
        this.curBufPos = 0;
        this.curBufDataBytes = this.curBufVEleAt == this.lastBufVEleAt ? this.lastBufDataBytes : this.bufSize;
    }

    @Override
    public int read() throws IOException {
        SanityManager.ASSERT(!this.writing, "Reading should be true 2");
        if (this.curBufPos >= this.curBufDataBytes) {
            this.getNextBuffer_r();
        }
        if (this.curBufPos >= this.curBufDataBytes) {
            return -1;
        }
        return 0xFF & this.curBuf[this.curBufPos++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(b, off, null, len);
    }

    @Override
    public int read(OutputStream out, int len) throws IOException {
        return this.read(null, 0, out, len);
    }

    public int read(byte[] b, int off, OutputStream out, int len) throws IOException {
        int bytesIRead = 0;
        boolean eof = false;
        SanityManager.ASSERT(!this.writing, "Reading should be true 3");
        if (this.curBufPos >= this.curBufDataBytes) {
            eof = this.getNextBuffer_r();
        }
        if (eof) {
            return -1;
        }
        while (len > 0 && !eof) {
            int bytesInCurBuf = this.curBufDataBytes - this.curBufPos;
            int bytesIReadThisTime = len >= bytesInCurBuf ? bytesInCurBuf : len;
            if (out == null) {
                System.arraycopy(this.curBuf, this.curBufPos, b, off, bytesIReadThisTime);
            } else {
                out.write(this.curBuf, this.curBufPos, bytesIReadThisTime);
            }
            off += bytesIReadThisTime;
            this.curBufPos += bytesIReadThisTime;
            len -= bytesIReadThisTime;
            bytesIRead += bytesIReadThisTime;
            if (this.curBufPos < this.curBufDataBytes) continue;
            eof = this.getNextBuffer_r();
        }
        return bytesIRead;
    }

    @Override
    public int shiftToFront() throws IOException {
        int remainingBytes = this.available();
        remainingBytes = remainingBytes > 0 ? remainingBytes : -1 * remainingBytes;
        byte[] b = new byte[remainingBytes + 1];
        int bytesRead = this.read(b, 0, remainingBytes);
        this.clear();
        this.writing = true;
        this.write(b, 0, bytesRead);
        this.curBufDataBytes = 0;
        return bytesRead;
    }

    @Override
    public int available() {
        int curBufAvailable = this.curBufDataBytes - this.curBufPos;
        int lastBufAvailable = 0;
        int middleBuffers = 0;
        if (this.curBufVEleAt != this.lastBufVEleAt) {
            middleBuffers = this.lastBufVEleAt - this.curBufVEleAt - 1;
            lastBufAvailable = this.lastBufDataBytes;
        }
        int availableBytes = curBufAvailable + lastBufAvailable + middleBuffers * this.bufSize;
        return availableBytes;
    }

    @Override
    public int numBytesSaved() {
        int ret_val;
        if (this.writing) {
            SanityManager.ASSERT(this.lastBufVEleAt == 0 && this.lastBufDataBytes == 0, "counters were somehow bumped during writing");
            ret_val = this.curBufVEleAt * this.bufSize + this.curBufPos;
        } else {
            ret_val = this.lastBufVEleAt * this.bufSize + this.lastBufDataBytes;
        }
        return ret_val;
    }

    @Override
    public long skip(long count) throws IOException {
        long bytesISkipped = 0L;
        boolean eof = false;
        SanityManager.ASSERT(!this.writing, "Reading should be true 4");
        if (this.curBufPos >= this.curBufDataBytes) {
            eof = this.getNextBuffer_r();
        }
        while (count > 0L && !eof) {
            int bytesInCurBuf = this.curBufDataBytes - this.curBufPos;
            int bytesISkippedThisTime = count >= (long)bytesInCurBuf ? bytesInCurBuf : (int)count;
            this.curBufPos += bytesISkippedThisTime;
            bytesISkipped += (long)bytesISkippedThisTime;
            if ((count -= (long)bytesISkippedThisTime) <= 0L) continue;
            eof = this.getNextBuffer_r();
        }
        return bytesISkipped;
    }

    @Override
    public boolean writingMode() {
        return this.writing;
    }

    @Override
    public ByteHolder cloneEmpty() {
        return new MemByteHolder(this.bufSize);
    }

    protected void getNextBuffer_w() throws IOException {
        this.getNextBuffer_w_Sanity();
        ++this.curBufVEleAt;
        if (this.bufV.size() <= this.curBufVEleAt) {
            this.curBuf = new byte[this.bufSize];
            this.bufV.addElement(this.curBuf);
        } else {
            this.curBuf = this.bufV.elementAt(this.curBufVEleAt);
        }
        this.initBuffer_w();
    }

    protected void getNextBuffer_w_Sanity() {
        SanityManager.ASSERT(this.curBufPos == this.curBuf.length, "partial write");
        SanityManager.ASSERT(this.writing, "Writing should be true 5");
    }

    protected void initBuffer_w() {
        this.curBufPos = 0;
        SanityManager.ASSERT(this.curBuf.length == this.bufSize, "bad Buf Length " + this.curBuf.length);
    }

    protected boolean getNextBuffer_r() throws IOException {
        SanityManager.ASSERT(!this.writing, "Reading should be true 5");
        if (this.curBufVEleAt >= this.lastBufVEleAt) {
            return true;
        }
        this.curBuf = this.bufV.elementAt(++this.curBufVEleAt);
        this.curBufPos = 0;
        this.curBufDataBytes = this.curBufVEleAt == this.lastBufVEleAt ? this.lastBufDataBytes : this.bufSize;
        return false;
    }

    private String dumpBuf(int bufVEleAt) {
        StringBuffer sb = new StringBuffer(100);
        byte[] buf = this.bufV.elementAt(bufVEleAt);
        sb.append("(");
        for (int ix = 0; ix < buf.length; ++ix) {
            sb.append(buf[ix] + ".");
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return " writing: " + this.writing + " curBufVEleAt: " + this.curBufVEleAt + " curBufPos: " + this.curBufPos + " curBufDataBytes: " + this.curBufDataBytes + " lastBufVEleAt: " + this.lastBufVEleAt + " lastBufDataBytes: " + this.lastBufDataBytes + " curBuf: " + this.dumpBuf(this.curBufVEleAt);
    }
}

