/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.shared.common.error.StandardException;

class SetConstraintsConstantAction
extends DDLConstantAction {
    private final boolean deferred;
    private final List<TableName> constraints;

    SetConstraintsConstantAction(List<TableName> constraints, boolean deferred) {
        this.constraints = constraints;
        this.deferred = deferred;
    }

    public String toString() {
        return "SET CONSTRAINTS";
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        ArrayList<CallSite> boundConstraints = new ArrayList<CallSite>();
        if (this.constraints != null) {
            for (TableName c : this.constraints) {
                SchemaDescriptor sd = dd.getSchemaDescriptor(c.getSchemaName(), lcc.getTransactionExecute(), true);
                ConstraintDescriptor cd = dd.getConstraintDescriptor(c.getTableName(), sd.getUUID());
                if (cd == null) {
                    throw StandardException.newException("42X94", "CONSTRAINT", c.getFullSQLName());
                }
                String bound = IdUtil.normalToDelimited(sd.getSchemaName()) + "." + IdUtil.normalToDelimited(cd.getConstraintName());
                if (boundConstraints.contains(bound)) {
                    throw StandardException.newException("42734", cd.getConstraintName(), bound);
                }
                boundConstraints.add((CallSite)((Object)bound));
                if (this.deferred && !cd.deferrable()) {
                    throw StandardException.newException("X0Y91.S", cd.getConstraintName());
                }
                lcc.setConstraintDeferred(activation, cd, this.deferred);
            }
        } else {
            lcc.setDeferredAll(activation, this.deferred);
        }
    }
}

