/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.net4j.buddies.common.IAccount;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.IBuddyStateEvent;
import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.common.ISession;
import org.eclipse.net4j.buddies.internal.common.Account;
import org.eclipse.net4j.buddies.internal.common.Buddy;
import org.eclipse.net4j.buddies.internal.common.Collaboration;
import org.eclipse.net4j.buddies.internal.common.CollaborationContainer;
import org.eclipse.net4j.buddies.internal.common.Membership;
import org.eclipse.net4j.buddies.internal.common.protocol.BuddyStateNotification;
import org.eclipse.net4j.buddies.internal.server.ServerBuddy;
import org.eclipse.net4j.buddies.internal.server.ServerSession;
import org.eclipse.net4j.buddies.internal.server.bundle.OM;
import org.eclipse.net4j.buddies.internal.server.protocol.BuddiesServerProtocol;
import org.eclipse.net4j.buddies.internal.server.protocol.BuddyRemovedNotification;
import org.eclipse.net4j.buddies.internal.server.protocol.CollaborationInitiatedNotification;
import org.eclipse.net4j.buddies.server.IBuddyAdmin;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class BuddyAdmin
extends CollaborationContainer
implements IBuddyAdmin {
    public static final BuddyAdmin INSTANCE = new BuddyAdmin();
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, BuddyAdmin.class);
    private ConcurrentMap<String, IAccount> accounts = new ConcurrentHashMap<String, IAccount>();
    private ConcurrentMap<String, ISession> sessions = new ConcurrentHashMap<String, ISession>();
    private long lastCollaborationID;

    public BuddyAdmin() {
        this.activate();
    }

    @Override
    public Map<String, IAccount> getAccounts() {
        return this.accounts;
    }

    public ISession getSession(IBuddy buddy) {
        return this.getSession(buddy.getUserID());
    }

    public ISession getSession(String userID) {
        return (ISession)this.sessions.get(userID);
    }

    public ISession[] getSessions() {
        return this.sessions.values().toArray(new ISession[this.sessions.size()]);
    }

    public IBuddy[] getBuddies() {
        ArrayList<IBuddy> buddies = new ArrayList<IBuddy>();
        for (ISession session : this.sessions.values()) {
            buddies.add(session.getSelf());
        }
        return buddies.toArray(new IBuddy[buddies.size()]);
    }

    public IBuddy getBuddy(String userID) {
        ISession session = this.getSession(userID);
        if (session == null) {
            return null;
        }
        return session.getSelf();
    }

    @Override
    public synchronized ISession openSession(IChannel channel, String userID, String password, String[] facilityTypes) {
        if (this.sessions.containsKey(userID)) {
            return null;
        }
        IAccount account = (IAccount)this.accounts.get(userID);
        if (account != null) {
            if (!account.authenticate(password)) {
                return null;
            }
        } else {
            account = new Account(userID, password);
            this.accounts.put(userID, account);
        }
        ServerBuddy buddy = new ServerBuddy(account, facilityTypes);
        buddy.activate();
        buddy.addListener((IListener)this);
        BuddiesServerProtocol protocol = (BuddiesServerProtocol)channel.getReceiveHandler();
        ServerSession session = new ServerSession(protocol, (IBuddy)buddy);
        protocol.setInfraStructure((Object)session);
        session.addListener((IListener)this);
        buddy.setSession(session);
        LifecycleUtil.activate((Object)((Object)session));
        if (TRACER.isEnabled()) {
            TRACER.trace("Opened session: " + userID);
        }
        this.sessions.put(userID, session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public ICollaboration initiateCollaboration(IBuddy initiator, String ... userIDs) {
        void var8_11;
        long collaborationID;
        BuddyAdmin buddyAdmin = this;
        synchronized (buddyAdmin) {
            collaborationID = ++this.lastCollaborationID;
        }
        Collaboration collaboration = new Collaboration(collaborationID);
        collaboration.activate();
        Membership.create((IBuddy)initiator, (ICollaboration)collaboration);
        HashSet<Object> buddies = new HashSet<Object>();
        buddies.add(initiator);
        String[] stringArray = userIDs;
        int n = userIDs.length;
        boolean n2 = false;
        while (var8_11 < n) {
            String userID = stringArray[var8_11];
            Buddy buddy = (Buddy)this.getBuddy(userID);
            if (buddy != null) {
                buddies.add(buddy);
                Membership.create((IBuddy)buddy, (ICollaboration)collaboration);
            }
            ++var8_11;
        }
        this.addCollaboration((ICollaboration)collaboration);
        HashSet<IBuddy> invitations = new HashSet<IBuddy>(buddies);
        for (IBuddy iBuddy : buddies) {
            if (iBuddy == initiator) continue;
            try {
                try {
                    invitations.remove(iBuddy);
                    BuddiesServerProtocol protocol = (BuddiesServerProtocol)iBuddy.getSession().getProtocol();
                    new CollaborationInitiatedNotification(protocol, collaborationID, invitations, null).sendAsync();
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                    invitations.add(iBuddy);
                    continue;
                }
            }
            catch (Throwable throwable) {
                invitations.add(iBuddy);
                throw throwable;
            }
            invitations.add(iBuddy);
        }
        return collaboration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(IEvent event) {
        if (event.getSource() instanceof ServerSession) {
            if (event instanceof ILifecycleEvent && ((ILifecycleEvent)event).getKind() == ILifecycleEvent.Kind.DEACTIVATED) {
                String userID = ((ServerSession)event.getSource()).getSelf().getUserID();
                BuddyAdmin buddyAdmin = this;
                synchronized (buddyAdmin) {
                    ServerSession removed = (ServerSession)((Object)this.sessions.remove(userID));
                    if (removed != null) {
                        removed.removeListener((IListener)this);
                        removed.getSelf().removeListener((IListener)this);
                        for (ISession session : this.sessions.values()) {
                            try {
                                BuddiesServerProtocol protocol = (BuddiesServerProtocol)session.getProtocol();
                                new BuddyRemovedNotification(protocol, userID).sendAsync();
                            }
                            catch (Exception ex) {
                                OM.LOG.error((Throwable)ex);
                            }
                        }
                    }
                }
            }
        } else if (event.getSource() instanceof ServerBuddy && event instanceof IBuddyStateEvent) {
            IBuddyStateEvent e = (IBuddyStateEvent)event;
            BuddyAdmin buddyAdmin = this;
            synchronized (buddyAdmin) {
                for (ISession session : this.sessions.values()) {
                    try {
                        if (ObjectUtil.equals((Object)session.getSelf(), (Object)e.getSource())) continue;
                        BuddiesServerProtocol protocol = (BuddiesServerProtocol)session.getProtocol();
                        new BuddyStateNotification((SignalProtocol)protocol, e.getSource().getUserID(), e.getNewState()).sendAsync();
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                }
            }
        }
    }

    public static Set<String> getFacilityTypes() {
        return IPluginContainer.INSTANCE.getFactoryTypes("org.eclipse.net4j.buddies.serverFacilities");
    }
}

