/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.ui.CDOTopicProvider;
import org.eclipse.net4j.util.collection.ConcurrentArray;

public class DefaultTopicProvider
implements CDOTopicProvider {
    private final ConcurrentArray<CDOTopicProvider.Listener> listeners = new ConcurrentArray<CDOTopicProvider.Listener>(){

        protected CDOTopicProvider.Listener[] newArray(int length) {
            return new CDOTopicProvider.Listener[length];
        }
    };
    private final Set<CDOTopicProvider.Topic> topics = new HashSet<CDOTopicProvider.Topic>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOTopicProvider.Topic[] getTopics() {
        Set<CDOTopicProvider.Topic> set = this.topics;
        synchronized (set) {
            return this.topics.toArray(new CDOTopicProvider.Topic[this.topics.size()]);
        }
    }

    public boolean setTopics(CDOTopicProvider.Topic ... topics) {
        return this.setTopics(Arrays.asList(topics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTopics(Collection<CDOTopicProvider.Topic> topics) {
        ArrayList<CDOTopicProvider.Topic> removed = null;
        ArrayList<CDOTopicProvider.Topic> added = null;
        Collection<CDOTopicProvider.Topic> collection = topics;
        synchronized (collection) {
            Iterator<CDOTopicProvider.Topic> it = this.topics.iterator();
            while (it.hasNext()) {
                CDOTopicProvider.Topic existingTopic = it.next();
                if (topics.contains((Object)existingTopic)) continue;
                it.remove();
                if (removed == null) {
                    removed = new ArrayList<CDOTopicProvider.Topic>();
                }
                removed.add(existingTopic);
            }
            for (CDOTopicProvider.Topic topic : topics) {
                if (!this.topics.add(topic)) continue;
                if (added == null) {
                    added = new ArrayList<CDOTopicProvider.Topic>();
                }
                added.add(topic);
            }
        }
        boolean changed = false;
        if (removed != null) {
            changed = true;
            for (CDOTopicProvider.Topic topic : removed) {
                this.forEachTopicListener(l -> l.topicRemoved(this, topic));
            }
        }
        if (added != null) {
            changed = true;
            for (CDOTopicProvider.Topic topic : added) {
                this.forEachTopicListener(l -> l.topicAdded(this, topic));
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTopic(CDOTopicProvider.Topic topic) {
        boolean added;
        Set<CDOTopicProvider.Topic> set = this.topics;
        synchronized (set) {
            added = this.topics.add(topic);
        }
        if (added) {
            this.forEachTopicListener(l -> l.topicAdded(this, topic));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTopic(CDOTopicProvider.Topic topic) {
        boolean removed;
        Set<CDOTopicProvider.Topic> set = this.topics;
        synchronized (set) {
            removed = this.topics.remove((Object)topic);
        }
        if (removed) {
            this.forEachTopicListener(l -> l.topicRemoved(this, topic));
            return true;
        }
        return false;
    }

    @Override
    public void addTopicListener(CDOTopicProvider.Listener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeTopicListener(CDOTopicProvider.Listener listener) {
        this.listeners.remove((Object)listener);
    }

    private void forEachTopicListener(Consumer<CDOTopicProvider.Listener> handler) {
        CDOTopicProvider.Listener[] listenerArray = (CDOTopicProvider.Listener[])this.listeners.get();
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOTopicProvider.Listener listener = listenerArray[n2];
            try {
                handler.accept(listener);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }
}

