/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.apache.derby.client.BasicClientDataSource;
import org.apache.derby.client.ClientAutoloadedDriver;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.LogicalConnection;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.client.net.NetXAConnection;

public class ClientPooledConnection
implements PooledConnection {
    private boolean newPC_ = true;
    private ArrayList<ConnectionEventListener> listeners_ = new ArrayList();
    private int eventIterators;
    ClientConnection physicalConnection_ = null;
    NetXAConnection netXAPhysicalConnection_ = null;
    private final JDBCStatementCache statementCache;
    private LogicalConnection logicalConnection_ = null;
    protected LogWriter logWriter_ = null;
    protected int rmId_ = 0;
    private final CopyOnWriteArrayList<StatementEventListener> statementEventListeners = new CopyOnWriteArrayList();

    public ClientPooledConnection(BasicClientDataSource ds, LogWriter logWriter, String user, String password) throws SQLException {
        this.logWriter_ = logWriter;
        this.statementCache = ds.maxStatementsToPool() <= 0 ? null : new JDBCStatementCache(ds.maxStatementsToPool());
        try {
            this.physicalConnection_ = ClientAutoloadedDriver.getFactory().newNetConnection(this.logWriter_, user, password, ds, -1, false, this);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public ClientPooledConnection(BasicClientDataSource ds, LogWriter logWriter, String user, String password, int rmId) throws SQLException {
        this.logWriter_ = logWriter;
        this.rmId_ = rmId;
        this.statementCache = ds.maxStatementsToPool() <= 0 ? null : null;
        try {
            this.netXAPhysicalConnection_ = new NetXAConnection(logWriter, user, password, ds, rmId, true, this);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        this.physicalConnection_ = this.netXAPhysicalConnection_.getNetConnection();
    }

    public boolean isStatementPoolingEnabled() {
        return this.statementCache != null;
    }

    protected void finalize() throws Throwable {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "finalize", new Object[0]);
        }
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            if (this.logWriter_ != null) {
                this.logWriter_.traceEntry(this, "close", new Object[0]);
            }
            if (this.logicalConnection_ != null) {
                this.logicalConnection_.nullPhysicalConnection();
                this.logicalConnection_ = null;
            }
            if (this.physicalConnection_ == null) {
                return;
            }
            this.physicalConnection_.closeResources();
        }
        finally {
            this.physicalConnection_ = null;
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        try {
            if (this.logWriter_ != null) {
                this.logWriter_.traceEntry(this, "getConnection", new Object[0]);
            }
            this.createLogicalConnection();
            if (!this.newPC_) {
                this.physicalConnection_.reset(this.logWriter_);
            } else {
                this.physicalConnection_.lightReset();
            }
            this.newPC_ = false;
            if (this.logWriter_ != null) {
                this.logWriter_.traceExit((Object)this, "getConnection", this.logicalConnection_);
            }
            return this.logicalConnection_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void createLogicalConnection() throws SqlException {
        if (this.physicalConnection_ == null) {
            throw new SqlException(this.logWriter_, new ClientMessageId("08003.C.1"), new Object[0]);
        }
        try {
            if (this.physicalConnection_.transactionInProgress()) {
                this.physicalConnection_.rollback();
            }
        }
        catch (SQLException sqle) {
            throw new SqlException(sqle);
        }
        if (this.logicalConnection_ != null) {
            this.logicalConnection_.closeWithoutRecyclingToPool();
        }
        this.logicalConnection_ = this.statementCache == null ? ClientAutoloadedDriver.getFactory().newLogicalConnection(this.physicalConnection_, this) : ClientAutoloadedDriver.getFactory().newCachingLogicalConnection(this.physicalConnection_, this, this.statementCache);
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "addConnectionEventListener", listener);
        }
        if (listener == null) {
            return;
        }
        if (this.eventIterators > 0) {
            this.listeners_ = new ArrayList<ConnectionEventListener>(this.listeners_);
        }
        this.listeners_.add(listener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "removeConnectionEventListener", listener);
        }
        if (this.eventIterators > 0) {
            this.listeners_ = new ArrayList<ConnectionEventListener>(this.listeners_);
        }
        this.listeners_.remove(listener);
    }

    public synchronized void recycleConnection() {
        if (this.physicalConnection_.agent_.loggingEnabled()) {
            this.physicalConnection_.agent_.logWriter_.traceEntry(this, "recycleConnection", new Object[0]);
        }
        this.logicalConnection_ = null;
        this.fireConnectionEventListeners(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informListeners(SqlException exception) {
        if (exception.getErrorCode() < 40000) {
            return;
        }
        ClientPooledConnection clientPooledConnection = this;
        synchronized (clientPooledConnection) {
            this.fireConnectionEventListeners(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionEventListeners(SqlException exception) {
        if (!this.listeners_.isEmpty()) {
            ConnectionEvent event = exception == null ? new ConnectionEvent(this) : new ConnectionEvent(this, exception.getSQLException());
            ++this.eventIterators;
            try {
                for (ConnectionEventListener listener : this.listeners_) {
                    if (exception == null) {
                        listener.connectionClosed(event);
                        continue;
                    }
                    listener.connectionErrorOccurred(event);
                }
            }
            finally {
                --this.eventIterators;
            }
        }
    }

    public synchronized void nullLogicalConnection() {
        this.logicalConnection_ = null;
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "addStatementEventListener", listener);
        }
        if (listener != null) {
            this.statementEventListeners.add(listener);
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "removeConnectionEventListener", listener);
        }
        this.statementEventListeners.remove(listener);
    }

    public void onStatementClose(PreparedStatement statement) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent event = new StatementEvent(this, statement);
            for (StatementEventListener l : this.statementEventListeners) {
                l.statementClosed(event);
            }
        }
    }

    public void onStatementErrorOccurred(PreparedStatement statement, SQLException sqle) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent event = new StatementEvent(this, statement, sqle);
            for (StatementEventListener l : this.statementEventListeners) {
                l.statementErrorOccurred(event);
            }
        }
    }
}

