/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.StandardException;

class EmbedConnectionContext
extends ContextImpl
implements ConnectionContext {
    private SoftReference<EmbedConnection> connRef;

    EmbedConnectionContext(ContextManager cm, EmbedConnection conn) {
        super(cm, "JDBC_ConnectionContext");
        this.connRef = new SoftReference<EmbedConnection>(conn);
    }

    @Override
    public void cleanupOnError(Throwable error) {
        StandardException se;
        if (this.connRef == null) {
            return;
        }
        EmbedConnection conn = this.connRef.get();
        if (error instanceof StandardException && (se = (StandardException)error).getSeverity() < 40000) {
            if (conn != null) {
                conn.needCommit = false;
            }
            return;
        }
        if (conn != null) {
            conn.setInactive();
        }
        this.connRef = null;
        this.popMe();
    }

    @Override
    public Connection getNestedConnection(boolean internal) throws SQLException {
        StatementContext sc;
        EmbedConnection conn = this.connRef.get();
        if (conn == null || conn.isClosed()) {
            throw Util.noCurrentConnection();
        }
        if (!(internal || (sc = this.privilegedGetLCC(conn).getStatementContext()) != null && sc.getSQLAllowed() >= 0)) {
            throw Util.noCurrentConnection();
        }
        return conn.getLocalDriver().getNewNestedConnection(conn);
    }

    @Override
    public ResultSet getResultSet(org.apache.derby.iapi.sql.ResultSet executionResultSet) throws SQLException {
        EmbedConnection conn = this.connRef.get();
        EmbedResultSet rs = conn.getLocalDriver().newEmbedResultSet(conn, executionResultSet, false, null, true);
        return rs;
    }

    @Override
    public boolean processInaccessibleDynamicResult(ResultSet resultSet) {
        EmbedConnection conn = this.connRef.get();
        if (conn == null) {
            return false;
        }
        return EmbedStatement.processDynamicResult(conn, resultSet, null) != null;
    }

    private LanguageConnectionContext privilegedGetLCC(EmbedConnection conn) {
        return conn.getLanguageConnection();
    }
}

