/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.FileNotFoundException;
import org.apache.derby.impl.io.vfmem.BlockedByteArray;
import org.apache.derby.impl.io.vfmem.BlockedByteArrayInputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArrayOutputStream;

public class DataStoreEntry {
    private final String path;
    private final boolean isDir;
    private boolean isReadOnly = false;
    private final BlockedByteArray src;
    private volatile boolean released = false;

    public DataStoreEntry(String path, boolean isDir) {
        this.path = path;
        this.isDir = isDir;
        this.src = isDir ? null : new BlockedByteArray();
    }

    public boolean isDirectory() {
        this.checkIfReleased();
        return this.isDir;
    }

    BlockedByteArrayInputStream getInputStream() throws FileNotFoundException {
        this.checkIfReleased();
        if (this.isDir) {
            throw new FileNotFoundException("'" + this.path + "' is a directory");
        }
        return this.src.getInputStream();
    }

    BlockedByteArrayOutputStream getOutputStream(boolean append) throws FileNotFoundException {
        BlockedByteArrayOutputStream out;
        this.checkIfReleased();
        if (this.isDir) {
            throw new FileNotFoundException("'" + this.path + "' is a directory");
        }
        if (this.isReadOnly) {
            throw new FileNotFoundException("'" + this.path + "' is read-only");
        }
        if (append) {
            out = this.src.getOutputStream(this.src.length());
        } else {
            this.src.setLength(0L);
            out = this.src.getOutputStream(0L);
        }
        return out;
    }

    public long length() {
        this.checkIfReleased();
        return this.src.length();
    }

    public void setReadOnly() {
        this.checkIfReleased();
        this.isReadOnly = true;
    }

    public boolean isReadOnly() {
        this.checkIfReleased();
        return this.isReadOnly;
    }

    void release() {
        this.released = true;
        if (this.src != null) {
            this.src.release();
        }
    }

    public void setLength(long newLength) {
        this.checkIfReleased();
        this.src.setLength(newLength);
    }

    private void checkIfReleased() {
        if (this.released) {
            throw new IllegalStateException("Entry has been released.");
        }
    }
}

