/*
 * Copyright (c) 2009-2012, 2015, 2019, 2020 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.common.branch;

import org.eclipse.emf.cdo.common.util.CDONameProvider;

import org.eclipse.net4j.util.event.IEvent;

/**
 * A persistent, named {@link CDOBranchPoint branch point}.
 *
 * @author Eike Stepper
 * @since 3.0
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface CDOBranchTag extends CDOBranchPoint, CDONameProvider, Comparable<CDOBranchTag>
{
  /**
   * Returns the branch manager that manages this branch, never <code>null</code>.
   *
   * @since 4.11
   */
  public CDOBranchManager getBranchManager();

  /**
   * Returns the name of this branch tag.
   */
  @Override
  public String getName();

  /**
   * @since 4.11
   */
  public void setName(String name);

  /**
   * @since 4.11
   */
  public void move(CDOBranchPoint branchPoint);

  /**
   * @since 4.11
   */
  public void delete();

  /**
   * @since 4.11
   */
  public boolean isDeleted();

  /**
   * @author Eike Stepper
   * @since 4.11
   */
  public interface TagEvent extends IEvent
  {
    public CDOBranchTag getTag();
  }

  /**
   * @author Eike Stepper
   * @since 4.11
   */
  public interface TagRenamedEvent extends TagEvent
  {
    public String getOldName();

    public String getNewName();
  }

  /**
   * @author Eike Stepper
   * @since 4.11
   */
  public interface TagMovedEvent extends TagEvent
  {
    public CDOBranchPoint getOldBranchPoint();

    public CDOBranchPoint getNewBranchPoint();
  }

  /**
   * @author Eike Stepper
   * @since 4.11
   */
  public interface TagDeletedEvent extends TagEvent
  {
  }
}
