/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.mapping.IBranchDeletionSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.CommitInfoTable;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreTable;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.net4j.db.Batch;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ConsumerWithException;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class DBStoreTables
extends Lifecycle {
    private final PropertiesTable properties;
    private final PackageUnitsTable packageUnits;
    private final PackageInfosTable packageInfos;
    private final BranchesTable branches;
    private final TagsTable tags;
    private final LobsTable lobs;

    public DBStoreTables(IDBStore store) {
        this.properties = new PropertiesTable(store);
        this.packageUnits = new PackageUnitsTable(store);
        this.packageInfos = new PackageInfosTable(store);
        this.branches = new BranchesTable(store);
        this.tags = new TagsTable(store);
        this.lobs = new LobsTable(store);
    }

    public PropertiesTable properties() {
        return this.properties;
    }

    public PackageUnitsTable packageUnits() {
        return this.packageUnits;
    }

    public PackageInfosTable packageInfos() {
        return this.packageInfos;
    }

    public BranchesTable branches() {
        return this.branches;
    }

    public TagsTable tags() {
        return this.tags;
    }

    public LobsTable lobs() {
        return this.lobs;
    }

    protected void doActivate() throws Exception {
        this.properties.activate();
        this.packageUnits.activate();
        this.packageInfos.activate();
        this.branches.activate();
        this.tags.activate();
        this.lobs.activate();
    }

    protected void doDeactivate() throws Exception {
        this.lobs.deactivate();
        this.tags.deactivate();
        this.branches.deactivate();
        this.packageInfos.deactivate();
        this.packageUnits.deactivate();
        this.properties.deactivate();
    }

    public static final class BranchesTable
    extends DBStoreTable {
        private IDBField id;
        private IDBField name;
        private IDBField baseID;
        private IDBField baseTime;
        private String sqlCreateBranch;
        private String sqlLoadBranch;
        private String sqlRenameBranch;
        private String sqlLoadSubBranches;
        private String sqlLoadBranches;

        public BranchesTable(IDBStore store) {
            super(store, NAMES.BRANCHES);
        }

        public IDBField id() {
            return this.id;
        }

        public Pair<Integer, Long> createBranch(IDBConnection connection, int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
            if (branchID == Integer.MAX_VALUE) {
                branchID = ((DBStore)this.store()).getNextBranchID();
            } else if (branchID == Integer.MIN_VALUE) {
                branchID = ((DBStore)this.store()).getNextLocalBranchID();
            }
            IDBPreparedStatement stmt = connection.prepareStatement(this.sqlCreateBranch, IDBPreparedStatement.ReuseProbability.LOW);
            try {
                stmt.setInt(1, branchID);
                stmt.setString(2, branchInfo.getName());
                stmt.setInt(3, branchInfo.getBaseBranchID());
                stmt.setLong(4, branchInfo.getBaseTimeStamp());
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
                connection.commit();
                Pair pair = Pair.create((Object)branchID, (Object)branchInfo.getBaseTimeStamp());
                return pair;
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }

        public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(IDBConnection connection, int branchID) {
            InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo;
            IDBPreparedStatement stmt = connection.prepareStatement(this.sqlLoadBranch, IDBPreparedStatement.ReuseProbability.HIGH);
            IDBResultSet resultSet = null;
            try {
                stmt.setInt(1, branchID);
                resultSet = stmt.executeQuery();
                if (!resultSet.next()) {
                    throw new DBException("Branch with ID " + branchID + " does not exist");
                }
                String name = resultSet.getString(1);
                int baseBranchID = resultSet.getInt(2);
                long baseTimeStamp = resultSet.getLong(3);
                branchInfo = new InternalCDOBranchManager.BranchLoader.BranchInfo(name, baseBranchID, baseTimeStamp);
            }
            catch (SQLException ex) {
                try {
                    throw new DBException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtil.close(resultSet);
                    DBUtil.close((Statement)stmt);
                    throw throwable;
                }
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            return branchInfo;
        }

        public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(IDBConnection connection, int baseID) {
            InternalCDOBranchManager.BranchLoader.SubBranchInfo[] subBranchInfoArray;
            IDBPreparedStatement stmt = connection.prepareStatement(this.sqlLoadSubBranches, IDBPreparedStatement.ReuseProbability.HIGH);
            IDBResultSet resultSet = null;
            try {
                stmt.setInt(1, baseID);
                resultSet = stmt.executeQuery();
                ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo> result = new ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo>();
                while (resultSet.next()) {
                    int id = resultSet.getInt(1);
                    String name = resultSet.getString(2);
                    long baseTimeStamp = resultSet.getLong(3);
                    result.add(new InternalCDOBranchManager.BranchLoader.SubBranchInfo(id, name, baseTimeStamp));
                }
                subBranchInfoArray = result.toArray(new InternalCDOBranchManager.BranchLoader.SubBranchInfo[result.size()]);
            }
            catch (SQLException ex) {
                try {
                    throw new DBException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtil.close(resultSet);
                    DBUtil.close((Statement)stmt);
                    throw throwable;
                }
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            return subBranchInfoArray;
        }

        public int loadBranches(IDBConnection connection, int startID, int endID, CDOBranchHandler handler) {
            int n;
            int count = 0;
            IDBPreparedStatement stmt = connection.prepareStatement(this.sqlLoadBranches, IDBPreparedStatement.ReuseProbability.HIGH);
            IDBResultSet resultSet = null;
            InternalCDOBranchManager branchManager = (InternalCDOBranchManager)this.store().getRepository().getBranchManager();
            try {
                stmt.setInt(1, startID);
                stmt.setInt(2, endID > 0 ? endID : Integer.MAX_VALUE);
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    int branchID = resultSet.getInt(1);
                    String name = resultSet.getString(2);
                    int baseBranchID = resultSet.getInt(3);
                    long baseTimeStamp = resultSet.getLong(4);
                    InternalCDOBranch branch = branchManager.getBranch(branchID, new InternalCDOBranchManager.BranchLoader.BranchInfo(name, baseBranchID, baseTimeStamp));
                    handler.handleBranch((CDOBranch)branch);
                    ++count;
                }
                n = count;
            }
            catch (SQLException ex) {
                try {
                    throw new DBException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtil.close(resultSet);
                    DBUtil.close((Statement)stmt);
                    throw throwable;
                }
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            return n;
        }

        public CDOBranch[] deleteBranches(IDBStoreAccessor accessor, int branchID, OMMonitor monitor) {
            DBStore store = (DBStore)this.store();
            IDBConnection connection = accessor.getDBConnection();
            LinkedHashSet branches = store.getRepository().getBranchManager().getBranches(branchID);
            String idList = BranchesTable.buildIDList(branches);
            Throwable throwable = null;
            Object var9_10 = null;
            try (Batch batch = new Batch((Connection)connection, new String[0]);){
                CommitInfoTable commitInfoTable;
                batch.add("DELETE FROM " + this.table() + " WHERE " + this.id + " IN (" + idList + ")");
                TagsTable tags = store.tables().tags();
                batch.add("DELETE FROM " + (Object)((Object)tags) + " WHERE " + tags.branch() + " IN (" + idList + ")");
                IMappingStrategy mappingStrategy = store.getMappingStrategy();
                if (mappingStrategy instanceof IBranchDeletionSupport) {
                    ((IBranchDeletionSupport)((Object)mappingStrategy)).deleteBranches(accessor, batch, idList);
                }
                if ((commitInfoTable = store.getCommitInfoTable()) != null) {
                    commitInfoTable.deleteBranches(accessor, batch, idList);
                }
                store.getDurableLockingManager().deleteBranches(accessor, batch, idList);
                monitor.begin();
                OMMonitor.Async async = monitor.forkAsync();
                try {
                    try {
                        batch.execute();
                        connection.commit();
                    }
                    catch (SQLException ex) {
                        throw new DBException((Throwable)ex);
                    }
                }
                finally {
                    async.stop();
                    monitor.done();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return branches.toArray(new CDOBranch[branches.size()]);
        }

        public void renameBranch(IDBConnection connection, int branchID, String oldName, String newName) {
            IDBPreparedStatement stmt = connection.prepareStatement(this.sqlRenameBranch, IDBPreparedStatement.ReuseProbability.LOW);
            try {
                try {
                    stmt.setString(1, newName);
                    stmt.setInt(2, branchID);
                    DBUtil.update((PreparedStatement)stmt, (boolean)true);
                    connection.commit();
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }

        @Override
        protected void firstActivate(IDBTable table) {
            this.id = table.addField(NAMES.ID, DBType.INTEGER, true);
            this.name = table.addField(NAMES.NAME, DBType.VARCHAR);
            this.baseID = table.addField(NAMES.BASE_ID, DBType.INTEGER);
            this.baseTime = table.addField(NAMES.BASE_TIME, DBType.BIGINT);
            table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.id});
        }

        @Override
        protected void reActivate(IDBTable table) {
            this.id = table.getField(NAMES.ID);
            this.name = table.getField(NAMES.NAME);
            this.baseID = table.getField(NAMES.BASE_ID);
            this.baseTime = table.getField(NAMES.BASE_TIME);
        }

        @Override
        protected void initSQL(IDBTable table) {
            this.sqlCreateBranch = "INSERT INTO " + table + " (" + this.id + ", " + this.name + ", " + this.baseID + ", " + this.baseTime + ") VALUES (?, ?, ?, ?)";
            this.sqlLoadBranch = "SELECT " + this.name + ", " + this.baseID + ", " + this.baseTime + " FROM " + table + " WHERE " + this.id + "=?";
            this.sqlRenameBranch = "UPDATE " + table + " SET " + this.name + "=?" + " WHERE " + this.id + "=?";
            this.sqlLoadSubBranches = "SELECT " + this.id + ", " + this.name + ", " + this.baseTime + " FROM " + table + " WHERE " + this.baseID + "=?";
            this.sqlLoadBranches = "SELECT " + this.id + ", " + this.name + ", " + this.baseID + ", " + this.baseTime + " FROM " + table + " WHERE " + this.id + " BETWEEN ? AND ? ORDER BY " + this.id;
        }

        private static String buildIDList(Set<CDOBranch> branches) {
            StringBuilder builder = new StringBuilder();
            for (CDOBranch branch : branches) {
                StringUtil.appendSeparator((StringBuilder)builder, (String)", ");
                builder.append(branch.getID());
            }
            return builder.toString();
        }

        private static final class NAMES {
            private static final String BRANCHES = NAMES.name("cdo_branches");
            private static final String ID = NAMES.name("id");
            private static final String NAME = NAMES.name("name");
            private static final String BASE_ID = NAMES.name("base_id");
            private static final String BASE_TIME = NAMES.name("base_time");

            private NAMES() {
            }

            private static String name(String name) {
                return DBUtil.name((String)name, BranchesTable.class);
            }
        }
    }

    public static final class LobsTable
    extends DBStoreTable {
        private IDBField id;
        private IDBField size;
        private IDBField bdata;
        private IDBField cdata;
        private String sqlQueryLobs;
        private String sqlHandleLobs;
        private String sqlLoadLob;
        private String sqlWriteBlob;
        private String sqlWriteClob;

        public LobsTable(IDBStore store) {
            super(store, NAMES.LOBS);
        }

        public void queryLobs(IDBConnection connection, List<byte[]> ids) {
            IDBPreparedStatement stmt = connection.prepareStatement(this.sqlQueryLobs, IDBPreparedStatement.ReuseProbability.MEDIUM);
            IDBResultSet resultSet = null;
            try {
                try {
                    Iterator<byte[]> it = ids.iterator();
                    while (it.hasNext()) {
                        byte[] id = it.next();
                        stmt.setString(1, HexUtil.bytesToHex((byte[])id));
                        try {
                            resultSet = stmt.executeQuery();
                            if (resultSet.next()) continue;
                            it.remove();
                        }
                        finally {
                            DBUtil.close((ResultSet)resultSet);
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }

        public void loadLob(IDBConnection connection, byte[] id, OutputStream out) throws IOException {
            IDBPreparedStatement stmt = connection.prepareStatement(this.sqlLoadLob, IDBPreparedStatement.ReuseProbability.MEDIUM);
            IDBResultSet resultSet = null;
            try {
                try {
                    stmt.setString(1, HexUtil.bytesToHex((byte[])id));
                    resultSet = stmt.executeQuery();
                    resultSet.next();
                    long size = resultSet.getLong(1);
                    InputStream inputStream = resultSet.getBinaryStream(2);
                    if (resultSet.wasNull()) {
                        Reader reader = resultSet.getCharacterStream(3);
                        IOUtil.copyCharacter((Reader)reader, (Writer)new OutputStreamWriter(out), (long)size);
                    } else {
                        IOUtil.copyBinary((InputStream)inputStream, (OutputStream)out, (long)size);
                    }
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }

        public void handleLobs(IDBConnection connection, long fromTime, long toTime, CDOLobHandler handler) throws IOException {
            IDBPreparedStatement stmt = connection.prepareStatement(this.sqlHandleLobs, IDBPreparedStatement.ReuseProbability.LOW);
            IDBResultSet resultSet = null;
            try {
                try {
                    resultSet = stmt.executeQuery();
                    while (resultSet.next()) {
                        byte[] id = HexUtil.hexToBytes((String)resultSet.getString(1));
                        long size = resultSet.getLong(2);
                        InputStream inputStream = resultSet.getBinaryStream(3);
                        if (resultSet.wasNull()) {
                            Reader reader = resultSet.getCharacterStream(4);
                            Writer out = handler.handleClob(id, size);
                            if (out == null) continue;
                            try {
                                IOUtil.copyCharacter((Reader)reader, (Writer)out, (long)size);
                                continue;
                            }
                            finally {
                                IOUtil.close((Closeable)out);
                            }
                        }
                        OutputStream out = handler.handleBlob(id, size);
                        if (out == null) continue;
                        try {
                            IOUtil.copyBinary((InputStream)inputStream, (OutputStream)out, (long)size);
                        }
                        finally {
                            IOUtil.close((Closeable)out);
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            finally {
                DBUtil.close((ResultSet)resultSet);
                DBUtil.close((Statement)stmt);
            }
        }

        public void writeBlob(IDBConnection connection, byte[] id, long size, InputStream inputStream) throws IOException {
            IDBPreparedStatement stmt = connection.prepareStatement(this.sqlWriteBlob, IDBPreparedStatement.ReuseProbability.MEDIUM);
            try {
                try {
                    stmt.setString(1, HexUtil.bytesToHex((byte[])id));
                    stmt.setLong(2, size);
                    stmt.setBinaryStream(3, inputStream, (int)size);
                    DBUtil.update((PreparedStatement)stmt, (boolean)true);
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }

        public void writeClob(IDBConnection connection, byte[] id, long size, Reader reader) throws IOException {
            IDBPreparedStatement stmt = connection.prepareStatement(this.sqlWriteClob, IDBPreparedStatement.ReuseProbability.MEDIUM);
            try {
                try {
                    stmt.setString(1, HexUtil.bytesToHex((byte[])id));
                    stmt.setLong(2, size);
                    stmt.setCharacterStream(3, reader, (int)size);
                    DBUtil.update((PreparedStatement)stmt, (boolean)true);
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }

        @Override
        protected void firstActivate(IDBTable table) {
            this.id = table.addField(NAMES.ID, DBType.VARCHAR, 64, true);
            this.size = table.addField(NAMES.SIZE, DBType.BIGINT);
            this.bdata = table.addField(NAMES.BDATA, DBType.BLOB);
            this.cdata = table.addField(NAMES.CDATA, DBType.CLOB);
            table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.id});
        }

        @Override
        protected void reActivate(IDBTable table) {
            this.id = table.getField(NAMES.ID);
            this.size = table.getField(NAMES.SIZE);
            this.bdata = table.getField(NAMES.BDATA);
            this.cdata = table.getField(NAMES.CDATA);
        }

        @Override
        protected void initSQL(IDBTable table) {
            this.sqlQueryLobs = "SELECT 1 FROM " + table + " WHERE " + this.id + "=?";
            this.sqlHandleLobs = "SELECT " + this.id + ", " + this.size + ", " + this.bdata + ", " + this.cdata + " FROM " + table;
            this.sqlLoadLob = "SELECT " + this.size + ", " + this.bdata + ", " + this.cdata + " FROM " + table + " WHERE " + this.id + "=?";
            this.sqlWriteBlob = "INSERT INTO " + table + "(" + this.id + ", " + this.size + ", " + this.bdata + ") VALUES(?, ?, ?)";
            this.sqlWriteClob = "INSERT INTO " + table + "(" + this.id + ", " + this.size + ", " + this.cdata + ") VALUES(?, ?, ?)";
        }

        public static String tableName() {
            return NAMES.LOBS;
        }

        public static String sizeName() {
            return NAMES.SIZE;
        }

        private static final class NAMES {
            private static final String LOBS = NAMES.name("cdo_lobs");
            private static final String ID = NAMES.name("id");
            private static final String SIZE = NAMES.name("lsize");
            private static final String BDATA = NAMES.name("bdata");
            private static final String CDATA = NAMES.name("cdata");

            private NAMES() {
            }

            private static String name(String name) {
                return DBUtil.name((String)name, LobsTable.class);
            }
        }
    }

    public static final class PackageInfosTable
    extends DBStoreTable {
        private IDBField uri;
        private IDBField parent;
        private IDBField unit;

        public PackageInfosTable(IDBStore store) {
            super(store, NAMES.PACKAGE_INFOS);
        }

        public IDBField uri() {
            return this.uri;
        }

        public IDBField parent() {
            return this.parent;
        }

        public IDBField unit() {
            return this.unit;
        }

        @Override
        protected void firstActivate(IDBTable table) {
            this.uri = table.addField(NAMES.URI, DBType.VARCHAR, 255, true);
            this.parent = table.addField(NAMES.PARENT, DBType.VARCHAR, 255);
            this.unit = table.addField(NAMES.UNIT, DBType.VARCHAR, 255);
            table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.uri});
            table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.parent});
            table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.unit});
        }

        @Override
        protected void reActivate(IDBTable table) {
            this.uri = table.getField(NAMES.URI);
            this.parent = table.getField(NAMES.PARENT);
            this.unit = table.getField(NAMES.UNIT);
        }

        private static final class NAMES {
            private static final String PACKAGE_INFOS = NAMES.name("cdo_package_infos");
            private static final String URI = NAMES.name("uri");
            private static final String PARENT = NAMES.name("parent");
            private static final String UNIT = NAMES.name("unit");

            private NAMES() {
            }

            private static String name(String name) {
                return DBUtil.name((String)name, PackageInfosTable.class);
            }
        }
    }

    public static final class PackageUnitsTable
    extends DBStoreTable {
        private IDBField id;
        private IDBField originalType;
        private IDBField timeStamp;
        private IDBField packageData;

        public PackageUnitsTable(IDBStore store) {
            super(store, NAMES.PACKAGE_UNITS);
        }

        public IDBField id() {
            return this.id;
        }

        public IDBField originalType() {
            return this.originalType;
        }

        public IDBField timeStamp() {
            return this.timeStamp;
        }

        public IDBField packageData() {
            return this.packageData;
        }

        public byte[] loadPackageUnitBytes(Connection connection, InternalCDOPackageUnit packageUnit) {
            String where = this.id + "='" + packageUnit.getID() + "'";
            Object[] values = DBUtil.select((Connection)connection, (String)where, (IDBField[])new IDBField[]{this.packageData});
            return (byte[])values[0];
        }

        @Override
        protected void firstActivate(IDBTable table) {
            this.id = table.addField(NAMES.ID, DBType.VARCHAR, 255, true);
            this.originalType = table.addField(NAMES.ORIGINAL_TYPE, DBType.INTEGER);
            this.timeStamp = table.addField(NAMES.TIME_STAMP, DBType.BIGINT);
            this.packageData = table.addField(NAMES.PACKAGE_DATA, DBType.BLOB);
            table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.id});
        }

        @Override
        protected void reActivate(IDBTable table) {
            this.id = table.getField(NAMES.ID);
            this.originalType = table.getField(NAMES.ORIGINAL_TYPE);
            this.timeStamp = table.getField(NAMES.TIME_STAMP);
            this.packageData = table.getField(NAMES.PACKAGE_DATA);
        }

        private static final class NAMES {
            private static final String PACKAGE_UNITS = NAMES.name("cdo_package_units");
            private static final String ID = NAMES.name("id");
            private static final String ORIGINAL_TYPE = NAMES.name("original_type");
            private static final String TIME_STAMP = NAMES.name("time_stamp");
            private static final String PACKAGE_DATA = NAMES.name("package_data");

            private NAMES() {
            }

            private static String name(String name) {
                return DBUtil.name((String)name, PackageUnitsTable.class);
            }
        }
    }

    public static final class PropertiesTable
    extends DBStoreTable {
        private IDBField name;
        private IDBField value;
        private String sqlDeleteProperties;
        private String sqlInsertProperties;
        private String sqlSelectProperties;
        private String sqlSelectAllProperties;

        public PropertiesTable(IDBStore store) {
            super(store, NAMES.PROPERTIES);
        }

        public Map<String, String> getPersistentProperties(Set<String> names) {
            HashMap<String, String> hashMap;
            IDBConnection connection = this.getConnection();
            IDBPreparedStatement stmt = null;
            String sql = null;
            try {
                HashMap<String, String> result = new HashMap<String, String>();
                boolean allProperties = ObjectUtil.isEmpty(names);
                if (allProperties) {
                    stmt = connection.prepareStatement(this.sqlSelectAllProperties, IDBPreparedStatement.ReuseProbability.MEDIUM);
                    IDBResultSet resultSet = null;
                    try {
                        resultSet = stmt.executeQuery();
                        while (resultSet.next()) {
                            String key = resultSet.getString(1);
                            String value = resultSet.getString(2);
                            result.put(key, value);
                        }
                    }
                    finally {
                        DBUtil.close((ResultSet)resultSet);
                    }
                } else {
                    stmt = connection.prepareStatement(this.sqlSelectProperties, IDBPreparedStatement.ReuseProbability.MEDIUM);
                    for (String name : names) {
                        stmt.setString(1, name);
                        IDBResultSet resultSet = null;
                        try {
                            resultSet = stmt.executeQuery();
                            if (!resultSet.next()) continue;
                            String value = resultSet.getString(1);
                            result.put(name, value);
                        }
                        finally {
                            DBUtil.close((ResultSet)resultSet);
                        }
                    }
                }
                hashMap = result;
            }
            catch (SQLException ex) {
                try {
                    throw new DBException((Throwable)ex, sql);
                }
                catch (Throwable throwable) {
                    DBUtil.close(stmt);
                    DBUtil.close((Connection)connection);
                    throw throwable;
                }
            }
            DBUtil.close((Statement)stmt);
            DBUtil.close((Connection)connection);
            return hashMap;
        }

        public void setPersistentProperties(Map<String, String> properties) {
            IDBConnection connection = this.getConnection();
            IDBPreparedStatement deleteStmt = connection.prepareStatement(this.sqlDeleteProperties, IDBPreparedStatement.ReuseProbability.MEDIUM);
            IDBPreparedStatement insertStmt = connection.prepareStatement(this.sqlInsertProperties, IDBPreparedStatement.ReuseProbability.MEDIUM);
            String msg = null;
            try {
                try {
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        String name = entry.getKey();
                        String value = entry.getValue();
                        msg = this.sqlDeleteProperties;
                        deleteStmt.setString(1, name);
                        deleteStmt.executeUpdate();
                        msg = this.sqlInsertProperties;
                        insertStmt.setString(1, name);
                        insertStmt.setString(2, value);
                        insertStmt.executeUpdate();
                    }
                    msg = "COMMIT";
                    connection.commit();
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex, msg);
                }
            }
            finally {
                DBUtil.close((Statement)insertStmt);
                DBUtil.close((Statement)deleteStmt);
                DBUtil.close((Connection)connection);
            }
        }

        public void removePersistentProperties(Set<String> names) {
            IDBConnection connection = this.getConnection();
            IDBPreparedStatement stmt = connection.prepareStatement(this.sqlDeleteProperties, IDBPreparedStatement.ReuseProbability.MEDIUM);
            try {
                try {
                    for (String name : names) {
                        stmt.setString(1, name);
                        stmt.executeUpdate();
                    }
                    connection.commit();
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex, this.sqlDeleteProperties);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
                DBUtil.close((Connection)connection);
            }
        }

        @Override
        protected void firstActivate(IDBTable table) {
            this.name = table.addField(NAMES.NAME, DBType.VARCHAR, 255, true);
            this.value = table.addField(NAMES.VALUE, DBType.LONGVARCHAR);
            table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.name});
        }

        @Override
        protected void reActivate(IDBTable table) {
            this.name = table.getField(NAMES.NAME);
            this.value = table.getField(NAMES.VALUE);
        }

        @Override
        protected void initSQL(IDBTable table) {
            this.sqlDeleteProperties = "DELETE FROM " + table + " WHERE " + this.name + "=?";
            this.sqlInsertProperties = "INSERT INTO " + table + " (" + this.name + ", " + this.value + ") VALUES (?, ?)";
            this.sqlSelectProperties = "SELECT " + this.value + " FROM " + table + " WHERE " + this.name + "=?";
            this.sqlSelectAllProperties = "SELECT " + this.name + ", " + this.value + " FROM " + table;
        }

        public static String tableName() {
            return NAMES.PROPERTIES;
        }

        public static String sqlSelectProperty(String name, String schemaName) {
            String tableName = DBUtil.quoted((String)NAMES.PROPERTIES);
            if (schemaName != null) {
                tableName = String.valueOf(DBUtil.quoted((String)schemaName)) + '.' + tableName;
            }
            return "SELECT " + DBUtil.quoted((String)NAMES.VALUE) + " FROM " + tableName + " WHERE " + DBUtil.quoted((String)NAMES.NAME) + "='" + name + "'";
        }

        private static final class NAMES {
            private static final String PROPERTIES = NAMES.name("cdo_properties");
            private static final String NAME = NAMES.name("name");
            private static final String VALUE = NAMES.name("value");

            private NAMES() {
            }

            private static String name(String name) {
                return DBUtil.name((String)name, PropertiesTable.class);
            }
        }
    }

    public static final class TagsTable
    extends DBStoreTable {
        private IDBField name;
        private IDBField branch;
        private IDBField timestamp;
        private String sqlCreateTag;
        private String sqlRenameTag;
        private String sqlMoveTag;
        private String sqlDeleteTag;
        private String sqlLoadTags;
        private String sqlLoadTag;

        public TagsTable(IDBStore store) {
            super(store, NAMES.TAGS);
        }

        public IDBField branch() {
            return this.branch;
        }

        public CDOBranchPoint changeTag(IDBConnection connection, AtomicInteger modCount, String oldName, String newName, CDOBranchPoint branchPoint) {
            switch (InternalCDOBranchManager.getTagChangeKind((String)oldName, (String)newName, (CDOBranchPoint)branchPoint)) {
                case CREATED: {
                    TagsTable.execSQL(connection, this.sqlCreateTag, (ConsumerWithException<IDBPreparedStatement, SQLException>)((ConsumerWithException)stmt -> {
                        stmt.setString(1, newName);
                        stmt.setInt(2, branchPoint.getBranch().getID());
                        stmt.setLong(3, branchPoint.getTimeStamp());
                    }));
                    break;
                }
                case RENAMED: {
                    TagsTable.execSQL(connection, this.sqlRenameTag, (ConsumerWithException<IDBPreparedStatement, SQLException>)((ConsumerWithException)stmt -> {
                        stmt.setString(1, newName);
                        stmt.setString(2, oldName);
                    }));
                    break;
                }
                case MOVED: {
                    TagsTable.execSQL(connection, this.sqlMoveTag, (ConsumerWithException<IDBPreparedStatement, SQLException>)((ConsumerWithException)stmt -> {
                        stmt.setInt(1, branchPoint.getBranch().getID());
                        stmt.setLong(2, branchPoint.getTimeStamp());
                        stmt.setString(3, oldName);
                    }));
                    break;
                }
                case DELETED: {
                    TagsTable.execSQL(connection, this.sqlDeleteTag, (ConsumerWithException<IDBPreparedStatement, SQLException>)((ConsumerWithException)stmt -> stmt.setString(1, oldName)));
                }
            }
            return null;
        }

        public void loadTags(IDBConnection connection, String name, Consumer<InternalCDOBranchManager.BranchLoader.BranchInfo> handler) {
            boolean single = name != null;
            String sql = single ? this.sqlLoadTag : this.sqlLoadTags;
            IDBPreparedStatement stmt = connection.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
            IDBResultSet resultSet = null;
            try {
                try {
                    if (single) {
                        stmt.setString(1, name);
                    }
                    resultSet = stmt.executeQuery();
                    while (resultSet.next()) {
                        int c = 0;
                        if (!single) {
                            name = resultSet.getString(++c);
                        }
                        int branchID = resultSet.getInt(++c);
                        long timeStamp = resultSet.getLong(++c);
                        handler.accept(new InternalCDOBranchManager.BranchLoader.BranchInfo(name, branchID, timeStamp));
                    }
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }

        @Override
        protected void firstActivate(IDBTable table) {
            this.name = table.addField(NAMES.NAME, DBType.VARCHAR, true);
            this.branch = table.addField(NAMES.BRANCH, DBType.INTEGER);
            this.timestamp = table.addField(NAMES.TIMESTAMP, DBType.BIGINT);
            table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.name});
        }

        @Override
        protected void reActivate(IDBTable table) {
            this.name = table.getField(NAMES.NAME);
            this.branch = table.getField(NAMES.BRANCH);
            this.timestamp = table.getField(NAMES.TIMESTAMP);
        }

        @Override
        protected void initSQL(IDBTable table) {
            this.sqlCreateTag = "INSERT INTO " + table + " (" + this.name + ", " + this.branch + ", " + this.timestamp + ") VALUES (?, ?, ?)";
            this.sqlRenameTag = "UPDATE " + table + " SET " + this.name + "=?" + " WHERE " + this.name + "=?";
            this.sqlMoveTag = "UPDATE " + table + " SET " + this.branch + "=?, " + this.timestamp + "=? WHERE " + this.name + "=?";
            this.sqlDeleteTag = "DELETE FROM " + table + " WHERE " + this.name + "=?";
            this.sqlLoadTags = "SELECT " + this.name + ", " + this.branch + ", " + this.timestamp + " FROM " + table;
            this.sqlLoadTag = "SELECT " + this.branch + ", " + this.timestamp + " FROM " + table + " WHERE " + this.name + "=?";
        }

        private static void execSQL(IDBConnection connection, String sql, ConsumerWithException<IDBPreparedStatement, SQLException> preparer) {
            IDBPreparedStatement stmt = connection.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
            try {
                try {
                    if (preparer != null) {
                        preparer.accept((Object)stmt);
                    }
                    DBUtil.update((PreparedStatement)stmt, (boolean)true);
                    connection.commit();
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }

        private static final class NAMES {
            private static final String TAGS = NAMES.name("cdo_tags");
            private static final String NAME = NAMES.name("name");
            private static final String BRANCH = NAMES.name("branch");
            private static final String TIMESTAMP = NAMES.name("timestamp");

            private NAMES() {
            }

            private static String name(String name) {
                return DBUtil.name((String)name, TagsTable.class);
            }
        }
    }
}

